package project.check.attribute;

import java.util.Optional;

import core.util.bean.Pair;
import online.context.check.ItemCheck;
import online.model.ModelUtil;
import project.check.BaseCheck;
import project.common.CheckUtil;

/**
 * 半角カナチェック
 *
 * @author Tadashi Nakayama
 * @version 1.0.0
 */
public final class HanKatakanaCheck extends BaseCheck implements ItemCheck {

	/** 正誤反転フラグ 1の時正誤反転 */
	private final boolean tfflg;
	/** メッセージID */
	private final String mid;
	/** メッセージパラメータ */
	private final String[] prm;

	/**
	 * コンストラクタ
	 */
	public HanKatakanaCheck() {
		this.tfflg = false;
		this.mid = null;
		this.prm = null;
	}

	/**
	 * コンストラクタ
	 *
	 * @param flg 正誤反転
	 * @param msgId メッセージID
	 * @param param メッセージパラメータ
	 */
	public HanKatakanaCheck(final boolean flg, final String msgId, final String... param) {
		this.tfflg = flg;
		this.mid = msgId;
		this.prm = copyOf(param);
	}

	/**
	 * @see online.context.check.ItemCheck#check(java.lang.String...)
	 */
	@Override
	public void check(final String... items) {
		Optional<Pair<String, Integer>> check = Optional.empty();
		for (final var item : items) {
			final var val = getArrayParameter(item);
			for (var j = 0; val != null && j < val.length; j++) {
				if (!isTarget(j)) {
					val[j] = ModelUtil.getValueAsString(getUniModel(), item, j);
				} else if ((this.tfflg && CheckUtil.hasHanKana(val[j]))
						|| (!this.tfflg && !CheckUtil.hasHanKana(val[j]))) {
					setMessage(item, j, this.mid, this.prm);
					check = Optional.of(check.orElse(Pair.of(item, j)));
				}
			}
		}

		check.ifPresent(this::throwKeepCheckException);
	}
}
