package common.db.dao.hibernate.platform;

import javax.transaction.TransactionManager;
import javax.transaction.UserTransaction;

import org.hibernate.engine.jndi.spi.JndiService;
import org.hibernate.engine.transaction.jta.platform.internal.AbstractJtaPlatform;

import common.db.jdbc.provider.S2DataSourceProvider;

/**
 * TomcatPlatform
 * @author Tadashi Nakayama
 */
public class TomcatJtaPlatform extends AbstractJtaPlatform {
	/** serialVersionUID */
	private static final long serialVersionUID = 1L;

	/**
	 * @see org.hibernate.engine.transaction.jta.platform.internal.AbstractJtaPlatform
	 * #locateTransactionManager()
	 */
	@Override
	protected TransactionManager locateTransactionManager() {
		return S2DataSourceProvider.getTransactionManager();
	}

	/**
	 * @see org.hibernate.engine.transaction.jta.platform.internal.AbstractJtaPlatform
	 * #locateUserTransaction()
	 */
	@Override
	protected UserTransaction locateUserTransaction() {
		return UserTransaction.class.cast(
			serviceRegistry().getService(JndiService.class).locate("java:/comp/UserTransaction"));
	}
}
