CREATE TABLE FW_JOB_BASE
(
  JOB_SEQ             NUMBER(10)     NOT NULL,
  JOB_ID              VARCHAR2(32)   NOT NULL,
  JOB_NAME            VARCHAR2(128)  NOT NULL,
  ENTRY_USER_ID       VARCHAR2(64)   NOT NULL,
  ENTRY_DATE_TIME     TIMESTAMP      NOT NULL,
  ENTRY_IP            VARCHAR2(64),
  JOB_PARAM           VARCHAR2(128),
  BAT_PARAM           VARCHAR2(512),
  DISP_PARAM          VARCHAR2(512),
  EXEC_HOST           VARCHAR2(64),
  STATUS              NUMBER(2)      NOT NULL,
  MESSAGE             VARCHAR2(512),
  REMARK              VARCHAR2(256)
)
;

ALTER TABLE FW_JOB_BASE ADD CONSTRAINT FW_JOB_BASE_PK PRIMARY KEY
(
  JOB_SEQ
)
;

COMMENT ON TABLE FW_JOB_BASE IS 'ジョブ管理';
COMMENT ON COLUMN FW_JOB_BASE.JOB_SEQ IS 'ジョブ連番';
COMMENT ON COLUMN FW_JOB_BASE.JOB_ID IS 'ジョブID';
COMMENT ON COLUMN FW_JOB_BASE.JOB_NAME IS 'ジョブ名';
COMMENT ON COLUMN FW_JOB_BASE.ENTRY_USER_ID IS '起動ユーザ';
COMMENT ON COLUMN FW_JOB_BASE.ENTRY_DATE_TIME IS '起動日時';
COMMENT ON COLUMN FW_JOB_BASE.ENTRY_IP IS '起動端末IP';
COMMENT ON COLUMN FW_JOB_BASE.JOB_PARAM IS 'ジョブ起動パラメタ';
COMMENT ON COLUMN FW_JOB_BASE.BAT_PARAM IS 'バッチ起動パラメタ';
COMMENT ON COLUMN FW_JOB_BASE.DISP_PARAM IS 'バッチ起動パラメタ（表示用）';
COMMENT ON COLUMN FW_JOB_BASE.EXEC_HOST IS '実行ホスト名';
COMMENT ON COLUMN FW_JOB_BASE.STATUS IS 'ステータス';
COMMENT ON COLUMN FW_JOB_BASE.MESSAGE IS 'メッセージ';
COMMENT ON COLUMN FW_JOB_BASE.REMARK IS '備考';
