package project.common.master;


/**
 * メッセージ
 *
 * @author Tadashi Nakayama
 * @version 1.0.0
 */
public interface Msg {
	/**
	 * 初期処理を行う。
	 */
	void initialize();

	/**
	 * プロパティメッセージ設定
	 */
	void setPropMessage();

	/**
	 * ソフト参照メッセージ設定
	 *
	 * @param code メッセージID
	 * @param msg メッセージ
	 * @param sts ステータス
	 */
	void setSoftMessage(String code, String msg, String sts);

	/**
	 * 強参照メッセージ設定
	 *
	 * @param code メッセージID
	 * @param msg メッセージ
	 * @param sts ステータス
	 */
	void setHardMessage(String code, String msg, String sts);

	/**
	 * メッセージを返す。
	 *
	 * @param code メッセージコード
	 * @param vals 可変項目
	 * @return String メッセージ
	 */
	String getMessage(String code, String... vals);

	/**
	 * ステータスを返す。
	 *
	 * @param code メッセージコード
	 * @return String ステータス
	 */
	String getStatus(String code);

	/**
	 * メッセージ存在確認
	 *
	 * @param code メッセージコード
	 * @return 存在している場合 true を返す。
	 */
	boolean contains(String code);

	/**
	 * メッセージフォーマッタ設定
	 *
	 * @param fmt メッセージフォーマッタ
	 */
	void setMsgFormatter(MsgFormatter fmt);

	/**
	 * メッセージフォーマッタ
	 *
	 * @author Tadashi Nakayama
	 * @version 1.0.0
	 */
	interface MsgFormatter {
		/**
		 * フォーマット処理
		 *
		 * @param code メッセージコード
		 * @param msg メッセージ
		 * @param vals 可変項目
		 * @return フォーマット後文字列
		 */
		String format(String code, String msg, String... vals);
	}
}
