package online.view.tag;

/**
 * キャッシュ制御タグライブラリ
 *
 * @author Tadashi Nakayama
 */
public class NoCacheTag extends BaseTag {
	/** serialVersionUID */
	private static final long serialVersionUID = 1L;

	/**
	 * @see javax.servlet.jsp.tagext.TagSupport#doStartTag()
	 */
	@Override
	public int doStartTag() {
		getResponse().setHeader("Pragma", "No-cache");
		getResponse().setHeader("Cache-Control", "no-cache,no-store,max-age=0");
		getResponse().setDateHeader("Expires", 1);
		return SKIP_BODY;
	}
}
