package online.view.tag;

import javax.servlet.http.Cookie;

import core.util.NumberUtil;
import online.view.ViewUtil;

/**
 * クッキータグライブラリ
 *
 * @author Tadashi Nakayama
 */
public class CookieTag extends BaseTag {
	/** serialVersionUID */
	private static final long serialVersionUID = 1L;

	/** 名前 */
	private String name;
	/** 値 */
	private String value;
	/** 期限 */
	private Integer expire;
	/** ドメイン */
	private String domain;
	/** パス */
	private String path;
	/** セキュア */
	private Boolean secure;
	/** httpOnly */
	private Boolean http;

	/**
	 * リリース処理
	 */
	@Override
	public void release() {
		this.name = null;
		this.value = null;
		this.expire = null;
		this.domain = null;
		this.path = null;
		this.secure = null;
		this.http = null;
	}

	/**
	 * 名前設定
	 *
	 * @param val 名前
	 */
	public void setName(final String val) {
		this.name = val;
	}

	/**
	 * 値設定
	 *
	 * @param val 値
	 */
	public void setValue(final String val) {
		this.value = val;
	}

	/**
	 * 期限設定
	 *
	 * @param val 期限
	 */
	public void setExpire(final String val) {
		this.expire = NumberUtil.toInteger(val);
	}

	/**
	 * ドメイン設定
	 *
	 * @param val ドメイン
	 */
	public void setDomain(final String val) {
		this.domain = val;
	}

	/**
	 * パス設定
	 *
	 * @param val パス
	 */
	public void setPath(final String val) {
		this.path = val;
	}

	/**
	 * セキュア設定
	 *
	 * @param val セキュア値
	 */
	public void setSecure(final String val) {
		this.secure = Boolean.valueOf(val);
	}

	/**
	 * httpOnly設定
	 *
	 * @param val httpOnly値
	 */
	public void seHttpOnly(final String val) {
		this.http = Boolean.valueOf(val);
	}

	/**
	 * @see javax.servlet.jsp.tagext.TagSupport#doStartTag()
	 */
	@Override
	public int doStartTag() {
		try {
			final Cookie ck = new Cookie(this.name, ViewUtil.noControl(this.value));
			if (this.expire != null) {
				ck.setMaxAge(this.expire);
			}
			if (this.domain != null) {
				ck.setDomain(this.domain);
			}
			if (this.path != null) {
				ck.setPath(this.path);
			}
			if (this.secure != null) {
				ck.setSecure(this.secure);
			}
			if (this.http != null) {
				ck.setHttpOnly(this.http);
			}
			getResponse().addCookie(ck);
			return SKIP_BODY;
		} finally {
			release();
		}
	}

}
