package online.listener;

import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;

import common.db.JdbcSource;
import online.view.ViewUtil;

/**
 * ドライバ抹消リスナ
 *
 * @author Tadashi Nakayama
 */
public class ContextListener implements ServletContextListener {

	/**
	 * @see javax.servlet.ServletContextListener
	 * #contextDestroyed(javax.servlet.ServletContextEvent)
	 */
	@Override
	public void contextDestroyed(final ServletContextEvent arg0) {
		JdbcSource.deregister(this.getClass().getClassLoader());
	}

	/**
	 * @see javax.servlet.ServletContextListener
	 * #contextInitialized(javax.servlet.ServletContextEvent)
	 */
	@Override
	public void contextInitialized(final ServletContextEvent arg0) {
		final var val = arg0.getServletContext().getInitParameter("referencesSanitize");
		if (val != null && !val.isEmpty()) {
			ViewUtil.setReferencesSanitize(Boolean.parseBoolean(val));
		}
	}
}
