package online.context.token;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

import javax.servlet.http.HttpServletRequest;

/**
 * トークン
 *
 * @author Tadashi Nakayama
 */
public interface Token {

	/** タグ TOKEN */
	String TAG_TOKEN = "TOKEN";

	/**
	 * ハッシュ文字列化
	 *
	 * @param val 文字列
	 * @return ハッシュ文字列
	 */
	String toHashString(String val);

	/**
	 * トークン設定
	 *
	 * @param request リクエスト
	 * @param token トークン文字列
	 */
	static void setTokenTo(final HttpServletRequest request, final String token) {
		request.setAttribute(TAG_TOKEN, token);
	}

	/**
	 * トークン取得
	 *
	 * @param request リクエスト
	 * @return トークン文字列
	 */
	static String getTokenFrom(final HttpServletRequest request) {
		return String.class.cast(request.getAttribute(TAG_TOKEN));
	}

	/**
	 * パラメータトークン設定
	 *
	 * @param request サーブレットリクエスト
	 */
	static void setParameterTokenTo(final HttpServletRequest request) {
		Optional.ofNullable(request.getParameter(TAG_TOKEN)).ifPresent(t -> setTokenTo(request, t));
	}

	/**
	 * トークン同一確認
	 *
	 * @param token 比較対象トークン文字列
	 * @param request リクエスト
	 * @return 同一の場合 true を返す。
	 */
	static boolean isSameToken(final String token, final HttpServletRequest request) {
		return Objects.equals(token, request.getParameter(TAG_TOKEN));
	}

	/**
	 * パラメータマップ取得
	 *
	 * @param request リクエスト
	 * @return パラメータマップ
	 */
	static Map<String, String[]> getParameterMapFrom(final HttpServletRequest request) {
		final var map = new HashMap<>(request.getParameterMap());
		map.remove(TAG_TOKEN);
		return map;
	}
}
