/*
 * $Id: MockServletConfig.java 471754 2006-11-06 14:55:09Z husted $
 *
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.apache.struts.mock;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;

import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;

/**
 * <p>Mock <strong>ServletConfig</strong> object for low-level unit tests of
 * Struts controller components.  Coarser grained tests should be implemented
 * in terms of the Cactus framework, instead of the mock object classes.</p>
 *
 * <p><strong>WARNING</strong> - Only the minimal set of methods needed to
 * create unit tests is provided, plus additional methods to configure this
 * object as necessary.  Methods for unsupported operations will throw
 * <code>UnsupportedOperationException</code>.</p>
 *
 * <p><strong>WARNING</strong> - Because unit tests operate in a single
 * threaded environment, no synchronization is performed.</p>
 *
 * @version $Rev: 471754 $ $Date: 2005-05-07 12:11:38 -0400 (Sat, 07 May 2005)
 *          $
 */
public class MockServletConfig implements ServletConfig {

    // ----------------------------------------------------- Instance Variables

    /** context */
    private ServletContext context = null;
    /** parameters */
    private final Map<String, String> parameters = new HashMap<>();

    // ----------------------------------------------------------- Constructors

    /**
     * MockServletConfig
     */
    public MockServletConfig() {
        super();
    }

    /**
     * @param ctx ServletContext
     */
    public MockServletConfig(final ServletContext ctx) {
        super();
        setServletContext(ctx);
    }

    // --------------------------------------------------------- Public Methods

    /**
     * @param name String
     * @param value String
     */
    public void addInitParameter(final String name, final String value) {
        this.parameters.put(name, value);
    }

    /**
     * @param ctx ServletContext
     */
    public void setServletContext(final ServletContext ctx) {
        this.context = ctx;
    }

    // ------------------------------------------------- ServletContext Methods

    /**
     * @see javax.servlet.ServletConfig#getInitParameter(java.lang.String)
     */
    @Override
    public String getInitParameter(final String name) {
        return this.parameters.get(name);
    }

    /**
     * @see javax.servlet.ServletConfig#getInitParameterNames()
     */
    @Override
    public Enumeration<String> getInitParameterNames() {
        return new MockEnumeration<>(this.parameters.keySet().iterator());
    }

    /**
     * @see javax.servlet.ServletConfig#getServletContext()
     */
    @Override
    public ServletContext getServletContext() {
        return this.context;
    }

    /**
     * @see javax.servlet.ServletConfig#getServletName()
     */
    @Override
    public String getServletName() {
        return "action";
    }
}
