/*
 * $Id: InvalidPathException.java 471754 2006-11-06 14:55:09Z husted $
 *
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.apache.struts.chain.commands;


/**
 * <p>Exception thrown when no mapping can be found for the specified
 * path.</p>
 *
 * @version $Rev: 471754 $ $Date: 2005-11-05 21:44:59 -0500 (Sat, 05 Nov 2005)
 *          $
 */
public class InvalidPathException extends RuntimeException {

    /** serialVersionUID */
    private static final long serialVersionUID = 5505779860386626636L;

    /** Field for Path property. */
    private final String path;

    /**
     * <p> Default, no-argument constructor. </p>
     */
    public InvalidPathException() {
        super();
        this.path = null;
    }

    /**
     * <p> Constructor to inject message and path upon instantiation. </p>
     *
     * @param message The error or warning message.
     * @param val    The invalid path.
     */
    public InvalidPathException(final String message, final String val) {
        super(message);
        this.path = val;
    }

    /**
     * <p> Return the invalid path causing the exception. </p>
     *
     * @return The invalid path causing the exception.
     */
    public String getPath() {
        return this.path;
    }
}
