package online.model;

import java.util.Date;

/**
 * JavaBean
 *
 */
public final class JavaBean {

	/** string */
	private String string;
	/** stringArray */
	private String[] stringArray;

	/** boolean */
	private boolean pbool;
	/** booleanArray */
	private boolean[] pboolArray;
	/** Boolean */
	private Boolean bool;
	/** BooleanArray */
	private Boolean[] boolArray;

	/** int */
	private int pint;
	/** intArray */
	private int[] pintArray;
	/** Integer */
	private Integer integer;
	/** IntegerArray */
	private Integer[] integerArray;

	/** Date */
	private Date date;
	/** DateArray */
	private Date[] dateArray;

	/**
	 * @return string
	 */
	public String getString() {
		return this.string;
	}

	/**
	 * @param val string
	 */
	public void setString(final String val) {
		this.string = val;
	}

	/**
	 * @return stringArray
	 */
	public String[] getStringArray() {
		return this.stringArray == null ? null : this.stringArray.clone();
	}

	/**
	 * @param val stringArray
	 */
	public void setStringArray(final String... val) {
		this.stringArray = val;
	}


	/**
	 * @return boolean
	 */
	public boolean isPrimitiveBoolean() {
		return this.pbool;
	}

	/**
	 * @param val boolean
	 */
	public void setPrimitiveBoolean(final boolean val) {
		this.pbool = val;
	}

	/**
	 * @return booleanArray
	 */
	public boolean[] isPrimitiveBooleanArray() {
		return this.pboolArray == null ? null : this.pboolArray.clone();
	}

	/**
	 * @param val booleanArray
	 */
	public void setPrimitiveBooleanArray(final boolean[] val) {
		this.pboolArray = val == null ? null : val.clone();
	}

	/**
	 * @return Boolean
	 */
	public Boolean isBoolean() {
		return this.bool;
	}

	/**
	 * @param val Boolean
	 */
	public void setBoolean(final Boolean val) {
		this.bool = val;
	}

	/**
	 * @return BooleanArray
	 */
	public Boolean[] isBooleanArray() {
		return this.boolArray == null ? null : this.boolArray.clone();
	}

	/**
	 * @param val BooleanArray
	 */
	public void setBooleanArray(final Boolean[] val) {
		this.boolArray = val == null ? null : val.clone();
	}


	/**
	 * @return int
	 */
	public int getPrimitiveInteger() {
		return this.pint;
	}

	/**
	 * @param val int
	 */
	public void setPrimitiveInteger(final int val) {
		this.pint = val;
	}

	/**
	 * @return intArray
	 */
	public int[] getPrimitiveIntegerArray() {
		return this.pintArray == null ? null : this.pintArray.clone();
	}

	/**
	 * @param val intArray
	 */
	public void setPrimitiveIntegerArray(final int[] val) {
		this.pintArray = val == null ? null : val.clone();
	}

	/**
	 * @return Integer
	 */
	public Integer getInteger() {
		return this.integer;
	}

	/**
	 * @param val Integer
	 */
	public void setInteger(final Integer val) {
		this.integer = val;
	}

	/**
	 * @return IntegerArray
	 */
	public Integer[] getIntegerArray() {
		return this.integerArray == null ? null : this.integerArray.clone();
	}

	/**
	 * @param val IntegerArray
	 */
	public void setIntegerArray(final Integer[] val) {
		this.integerArray = val == null ? null : val.clone();
	}


	/**
	 * @return Date
	 */
	public Date getDate() {
		return this.date == null ? null : new Date(this.date.getTime());
	}

	/**
	 * @param val Date
	 */
	public void setDate(final Date val) {
		this.date = val == null ? null : new Date(val.getTime());
	}

	/**
	 * @return DateArray
	 */
	public Date[] getDateArray() {
		return this.dateArray == null ? null : this.dateArray.clone();
	}

	/**
	 * @param val DateArray
	 */
	public void setDateArray(final Date[] val) {
		this.dateArray = val == null ? null : val.clone();
	}
}
