package project.web.auth;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.logging.log4j.LogManager;

import core.config.Factory;
import online.struts.action.BrowseAction;
import online.struts.action.UniForm;
import online.struts.mapping.RequestMapping;
import project.svc.auth.Authentication;

/**
 * ログオフアクション
 *
 * @author Tadashi Nakayama
 * @version 1.0.0
 */
public final class LogoffAction implements BrowseAction {

	/**
	 * ログオフ主処理
	 *
	 * @param mapping ActionMappingオブジェクト
	 * @param uf 汎用フォーム
	 * @param request HttpServletRequestオブジェクト
	 * @param response HttpServletResponseオブジェクト
	 * @return 処理結果
	 */
	@Override
	public String perform(final RequestMapping mapping, final UniForm uf,
			final HttpServletRequest request, final HttpServletResponse response) {
		final var session = request.getSession(false);
		if (session != null && uf.getSessionUser() != null) {
			try {
				// ログオフ処理
				final var auth = Factory.create(Authentication.class);
				auth.logoff(uf.getSessionUser().getUid(), session.getId(), uf.getPresent());
			} finally {
				uf.setSessionUser(null);
				try {
					session.invalidate();
				} catch (final IllegalStateException ex) {
					LogManager.getLogger().warn(ex.getMessage());
				}
			}
		}
		return ID_VIEW;
	}
}
