package project.svc.generic;

import java.io.Serializable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;

import common.db.JdbcSource;
import common.sql.QueryUtil;
import core.exception.PhysicalException;
import core.exception.ThrowableUtil;
import online.model.UniModel;
import project.base.QueryAbstract;

/**
 * 更新サービス
 * @author Tadashi Nakayama
 * @version 1.0.0
 */
public final class UpdateService extends QueryAbstract {

	/** クエリファイル */
	private String query = null;

	/**
	 * クエリファイル設定
	 * @param val クエリファイル
	 */
	public void setQueryFile(final String val) {
		this.query = val;
	}

	/**
	 * 更新処理
	 * @param um パラメタモデル
	 * @return 更新件数
	 */
	public int update(final UniModel um) {
		return update(um.toMap());
	}

	/**
	 * 更新処理
	 * @param map パラメタモデル
	 * @return 更新件数
	 */
	public int update(final Map<String, Serializable> map) {
		final var qry = QueryUtil.getSqlFromFile(this.query);
		if (!Objects.toString(qry, "").isEmpty()) {
			final var list = new ArrayList<>();
			try (var conn = JdbcSource.getConnection(getSchema())) {
				try (var psmt = conn.prepareStatement(
						QueryUtil.toPrepareQuery(qry, toParamMap(map), list))) {
					var i = 1;
					for (final var obj : list) {
						psmt.setObject(i++, obj);
					}
					return psmt.executeUpdate();
				}
			} catch (final SQLException ex) {
				ThrowableUtil.warn(ex);
				throw new PhysicalException(ex);
			}
		}
		return 0;
	}
}
