package project.master;

import java.util.List;

/**
 * コードマスタ取得保持
 *
 * @author Tadashi Nakayama
 * @version 1.0.0
 */
public interface CodeKeeper {

	/**
	 * 削除処理
	 *
	 * @param sbt コード種別
	 */
	void remove(String sbt);

	/**
	 * マスタ情報の存在と有効を確認
	 *
	 * @param sbt コード種別
	 * @param cd コード
	 * @return 存在し有効な場合 true
	 */
	boolean isValidCode(String sbt, String cd);

	/**
	 * 選択項目取得
	 *
	 * @param sbt コード種別
	 * @param cd コード
	 * @return コードマスタ
	 */
	Code getCode(String sbt, String cd);

	/**
	 * コードマスタリスト取得
	 *
	 * @param sbt コード種別
	 * @return コードマスタリスト
	 */
	List<Code> getCodeList(String sbt);

	/**
	 * 初期処理を行う。
	 */
	void initialize();

	/**
	 * コード
	 *
	 * @author Tadashi Nakayama
	 * @version 1.0.0
	 */
	class Code {
		/** 種別名 */
		private final String sbtName;
		/** コード */
		private final String code;
		/** コード名 */
		private final String name;
		/** コード略名 */
		private final String nameShort;
		/** コード略名プルダウン */
		private final String nameOption;
		/** 表示順 */
		private final String noOrder;
		/** コメント */
		private final String txComment;

		/**
		 * コンストラクタ
		 *
		 * @param sbt 種別名
		 * @param cd コード
		 * @param nam コード名
		 * @param sht コード略称
		 * @param opt コード略称プルダウン
		 * @param no 表示順
		 * @param tx コメント
		 */
		public Code(final String sbt, final String cd, final String nam, final String sht,
						final String opt, final String no, final String tx) {
			this.sbtName = sbt;
			this.code = cd;
			this.name = nam;
			this.nameShort = sht;
			this.nameOption = opt;
			this.noOrder = no;
			this.txComment = tx;
		}

		/**
		 * @return the sbtName
		 */
		public String getSbtName() {
			return this.sbtName;
		}

		/**
		 * @return the code
		 */
		public String getCode() {
			return this.code;
		}

		/**
		 * @return the name
		 */
		public String getName() {
			return this.name;
		}

		/**
		 * @return the nameShort
		 */
		public String getNameShort() {
			return this.nameShort;
		}

		/**
		 * @return the nameOption
		 */
		public String getNameOption() {
			return this.nameOption;
		}

		/**
		 * @return the noOrder
		 */
		public String getNoOrder() {
			return this.noOrder;
		}

		/**
		 * @return the txComment
		 */
		public String getTxComment() {
			return this.txComment;
		}
	}
}
