package project.check.master;

import java.util.Objects;
import java.util.Optional;

import core.config.Factory;
import core.util.bean.Pair;
import online.context.check.ItemCheck;
import online.model.ModelUtil;
import project.check.BaseCheck;
import project.master.CodeKeeper;


/**
 * コードマスタ存在チェック
 *
 * @author Tadashi Nakayama
 * @version 1.0.0
 */
public final class CodeCheck extends BaseCheck implements ItemCheck {

	/** コード区分 */
	private final String kubun;
	/** メッセージID */
	private final String mid;
	/** メッセージパラメータ */
	private final String[] prm;

	/**
	 * コンストラクタ
	 *
	 * @param kbn 区分
	 */
	public CodeCheck(final String kbn) {
		this.kubun = kbn;
		this.mid = null;
		this.prm = null;
	}

	/**
	 * コンストラクタ
	 *
	 * @param kbn 区分
	 * @param msgId メッセージID
	 * @param param メッセージパラメータ
	 */
	public CodeCheck(final String kbn, final String msgId, final String... param) {
		this.kubun = kbn;
		this.mid = msgId;
		this.prm = copyOf(param);
	}

	/**
	 * @see online.context.check.ItemCheck#check(java.lang.String...)
	 */
	@Override
	public void check(final String... items) {

		final var ck = Factory.create(CodeKeeper.class);

		Optional<Pair<String, Integer>> check = Optional.empty();
		for (final var item : items) {
			final var vals = getArrayParameter(item);
			for (var j = 0; vals != null && j < vals.length; j++) {
				if (!isTarget(j)) {
					vals[j] = ModelUtil.getValueAsString(getUniModel(), item, j);
				} else if (!Objects.toString(vals[j], "").isEmpty()) {
					if (!ck.isValidCode(this.kubun, vals[j])) {
						setMessage(item, j, this.mid, this.prm);
						check = Optional.of(check.orElse(Pair.of(item, j)));
					}
				}
			}
		}

		check.ifPresent(this::throwNoMoreCheckException);
	}
}
