package project.check.existence;

import java.util.Objects;
import java.util.Optional;

import core.util.bean.Pair;
import online.context.check.ItemCheck;
import project.check.BaseCheck;
import project.master.MsgUtil;

/**
 * 全く入力無しか、全て必須入力チェック
 *
 * @author Tadashi Nakayama
 * @version 1.0.0
 */
public final class AllorNothingCheck extends BaseCheck implements ItemCheck {

	/** メッセージID */
	private final String mid;
	/** メッセージパラメータ */
	private final String[] prm;

	/**
	 * コンストラクタ
	 */
	public AllorNothingCheck() {
		this.mid = null;
		this.prm = null;
	}

	/**
	 * コンストラクタ
	 *
	 * @param msgId メッセージID
	 * @param param メッセージパラメータ
	 */
	public AllorNothingCheck(final String msgId, final String... param) {
		this.mid = msgId;
		this.prm = copyOf(param);
	}

	/**
	 * @see online.context.check.ItemCheck#check(java.lang.String...)
	 */
	@Override
	public void check(final String... items) {
		Optional<Pair<String, Integer>> check = Optional.empty();
		for (final var item : items) {
			final var val = getArrayParameter(item);
			for (var j = 0; val != null && j < val.length; j++) {
				if (Objects.toString(val[j], "").isEmpty()) {
					if (!MsgUtil.hasItemMessage(getUniModel(), item)) {
						addTopMessage(this.mid, this.prm);
					}
					// if (!MsgUtil.hasItemMessage(getUniModel(), item, j)) {
					// 	MsgUtil.putItemMessage(getUniModel(), item, j, this.mid, this.prm);
					// }
					check = Optional.of(check.orElse(Pair.of(item, j)));
				}
			}
		}

		check.ifPresent(this::throwKeepCheckException);
	}
}
