package project.check;

import java.util.function.Consumer;

import core.config.Factory;
import core.exception.LogicalException;
import online.context.check.ItemCheckBase;
import project.common.master.Msg;

/**
 * トップメッセージ設定
 *
 * @author Tadashi Nakayama
 * @version 1.0.0
 */
public final class TopMessage extends ItemCheckBase implements Consumer<LogicalException> {

	/** メッセージID */
	private final String mid;
	/** メッセージパラメータ */
	private final String[] prm;
	/** リターンコード */
	private final String rc;

	/**
	 * コンストラクタ
	 * @param msgId メッセージID
	 * @param param メッセージパラメータ
	 */
	public TopMessage(final String msgId, final String... param) {
		this(null, msgId, param);
	}

	/**
	 * コンストラクタ
	 * @param status ステータスコード
	 * @param msgId メッセージID
	 * @param param メッセージパラメータ
	 */
	public TopMessage(final String status, final String msgId, final String... param) {
		this.mid = msgId;
		this.prm = (param != null) ? param.clone() : null;
		this.rc = status;
	}

	/**
	 * @see java.util.function.Consumer#accept(java.lang.Object)
	 */
	@Override
	public void accept(final LogicalException ex) {
		final var msg = Factory.create(Msg.class);
		getMessageList().add(0, msg.getMessage(this.mid, this.prm));
		getStatusList().add(0, msg.getStatus(this.mid));

		throw new LogicalException(ex.getMessage(), this.rc);
	}
}
