package online.view.tag;

/**
 * ステータス設定タグ
 *
 * @author Tadashi Nakayama
 */
public class StatusTag extends BaseTag {

	/** serialVersionUID */
	private static final long serialVersionUID = 1L;

	/** ステータス */
	private int status;

	/**
	 * ステータス設定
	 *
	 * @param val ステータス
	 */
	public void setStatus(final int val) {
		this.status = val;
	}

	/**
	 * @see javax.servlet.jsp.tagext.TagSupport#doStartTag()
	 */
	@Override
	public int doStartTag() {
		if (getResponse().getStatus() == 0) {
			getResponse().setStatus(this.status);
		}
		return SKIP_BODY;
	}
}
