package online.view.el;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

import online.view.model.ViewMap;
import core.config.Factory;

/**
 * バンドマップ
 *
 * @author Tadashi Nakayama
 */
final class BandMap implements Map<String, Serializable>, Serializable {

	/** serialVersionUID */
	private static final long serialVersionUID = 1L;

	/** ViewMap */
	private final ViewMap vm;
	/** 位置 */
	private int index = -1;

	/**
	 * コンストラクタ
	 *
	 * @param map ViewMap
	 */
	BandMap(final ViewMap map) {
		this.vm = map;
	}

	/**
	 * コンストラクタ
	 *
	 * @param map ViewMap
	 * @param i 位置
	 */
	BandMap(final ViewMap map, final int i) {
		this.vm = map;
		this.index = i;
	}

	/**
	 * 位置設定
	 *
	 * @param val 位置
	 */
	public void setIndex(final int val) {
		this.index = val;
	}

	/**
	 * @see java.util.Map#size()
	 */
	@Override
	public int size() {
		return this.vm.size();
	}

	/**
	 * @see java.util.Map#isEmpty()
	 */
	@Override
	public boolean isEmpty() {
		return this.vm.isEmpty();
	}

	/**
	 * @see java.util.Map#containsKey(java.lang.Object)
	 */
	@Override
	public boolean containsKey(final Object key) {
		return this.vm.containsKey(String.class.cast(key));
	}

	/**
	 * @see java.util.Map#containsValue(java.lang.Object)
	 */
	@Override
	public boolean containsValue(final Object value) {
		throw new UnsupportedOperationException();
	}

	/**
	 * @see java.util.Map#get(java.lang.Object)
	 */
	@Override
	public Serializable get(final Object key) {
		if (ViewMap.ATTR_UNSANI.equals(key)) {
			final var obj = this.vm.get(String.class.cast(key));
			if (ViewMap.class.isInstance(obj)) {
				return new BandMap(ViewMap.class.cast(obj), this.index);
			}
		}

		final Map<String, Serializable> m = Factory.cast(this.vm.get(ViewMap.ATTR_ARRAY));
		final List<Serializable> list = Factory.cast(m.get(String.class.cast(key)));
		if (list != null && 0 <= this.index) {
			return list.get(this.index);
		}
		return null;
	}

	/**
	 * @see java.util.Map#put(java.lang.Object, java.lang.Object)
	 */
	@Override
	public Serializable put(final String key, final Serializable value) {
		throw new UnsupportedOperationException();
	}

	/**
	 * @see java.util.Map#remove(java.lang.Object)
	 */
	@Override
	public Serializable remove(final Object key) {
		throw new UnsupportedOperationException();
	}

	/**
	 * @see java.util.Map#putAll(java.util.Map)
	 */
	@Override
	public void putAll(final Map<? extends String, ? extends Serializable> m) {
		throw new UnsupportedOperationException();
	}

	/**
	 * @see java.util.Map#clear()
	 */
	@Override
	public void clear() {
		throw new UnsupportedOperationException();
	}

	/**
	 * @see java.util.Map#keySet()
	 */
	@Override
	public Set<String> keySet() {
		return this.vm.keySet();
	}

	/**
	 * @see java.util.Map#values()
	 */
	@Override
	public Collection<Serializable> values() {
		throw new UnsupportedOperationException();
	}

	/**
	 * @see java.util.Map#entrySet()
	 */
	@Override
	public Set<Entry<String, Serializable>> entrySet() {
		throw new UnsupportedOperationException();
	}
}
