package online.context.check;

/**
 * 変換
 *
 * @param <R> ジェネリックス
 * @author Tadashi Nakayama
 */
@FunctionalInterface
public interface ItemConvert<R> {
	/**
	 * 変換
	 *
	 * @param val 値配列
	 * @return 返還後配列
	 */
	R[] convert(String... val);

	/**
	 * 引数返却変換
	 *
	 * @return 引数配列
	 */
	static ItemConvert<String> identity() {
		return val -> val;
	}
}
