/*
 * $Id: MessageResourcesConfig.java 471754 2006-11-06 14:55:09Z husted $
 *
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.apache.struts.config;

import org.apache.struts.Globals;

/**
 * <p>A JavaBean representing the configuration information of a
 * <code>&lt;message-resources&gt;</code> element in a Struts configuration
 * file.</p>
 *
 * @version $Rev: 471754 $ $Date: 2005-08-29 23:57:50 -0400 (Mon, 29 Aug 2005)
 *          $
 * @since Struts 1.1
 */
public class MessageResourcesConfig extends BaseConfig {

    /** serialVersionUID */
    private static final long serialVersionUID = -8689874577436806101L;

    // ------------------------------------------------------------- Properties

    /**
     * Fully qualified Java class name of the MessageResourcesFactory class we
     * should use.
     */
    private String factory =
        "org.apache.struts.util.PropertyMessageResourcesFactory";

    /**
     * The servlet context attributes key under which this MessageResources
     * instance is stored.
     */
    private String key = Globals.MESSAGES_KEY;

    /**
     * Should we return <code>null</code> for unknown message keys?
     */
    private boolean nullValue = true;

    /**
     * Indicates whether 'escape processing' should be performed on the error
     * message string.
     */
    private boolean escape = true;

    /**
     * Parameter that is passed to the <code>createResources()</code> method
     * of our MessageResourcesFactory implementation.
     */
    private String parameter = null;

    /**
     * @return Factory
     */
    public String getFactory() {
        return this.factory;
    }

    /**
     * @param val String
     */
    public void setFactory(final String val) {
        super.throwIfConfigured();

        this.factory = val;
    }

    /**
     * @return Key
     */
    public String getKey() {
        return this.key;
    }

    /**
     * @param val String
     */
    public void setKey(final String val) {
        super.throwIfConfigured();

        this.key = val;
    }

    /**
     * @return boolean
     */
    public boolean getNull() {
        return this.nullValue;
    }

    /**
     * @param val boolean
     */
    public void setNull(final boolean val) {
        super.throwIfConfigured();

        this.nullValue = val;
    }

    /**
     * Indicates whether 'escape processing' should be performed on the error
     * message string.
     * @return boolean
     * @since Struts 1.2.8
     */
    public boolean isEscape() {
        return this.escape;
    }

    /**
     * Set whether 'escape processing' should be performed on the error
     * message string.
     * @param val boolean
     * @since Struts 1.2.8
     */
    public void setEscape(final boolean val) {
        this.escape = val;
    }

    /**
     * @return Parameter
     */
    public String getParameter() {
        return this.parameter;
    }

    /**
     * @param val String
     */
    public void setParameter(final String val) {
        super.throwIfConfigured();

        this.parameter = val;
    }

    // --------------------------------------------------------- Public Methods

    /**
     * Return a String representation of this object.
     */
    @Override
    public String toString() {
        final String sb = "MessageResourcesConfig["
                + "factory=" + this.factory
                + ",null=" + this.nullValue
                + ",escape=" + this.escape
                + ",parameter=" + this.parameter
                + "]";
        return sb;
    }
}
