/*
 * $Id: RequestNoCache.java 471754 2006-11-06 14:55:09Z husted $
 *
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.apache.struts.chain.commands.servlet;

import org.apache.struts.chain.commands.AbstractRequestNoCache;
import org.apache.struts.chain.contexts.ActionContext;
import org.apache.struts.chain.contexts.ServletActionContext;

import javax.servlet.http.HttpServletResponse;

/**
 * <p>Check to see if the controller is configured to prevent caching, and if
 * so, set the no cache HTTP response headers.</p>
 *
 * @version $Rev: 471754 $ $Date: 2005-05-07 12:11:38 -0400 (Sat, 07 May 2005)
 *          $
 */
public class RequestNoCache extends AbstractRequestNoCache {

    // ------------------------------------------------------- Protected Methods

    /**
     * @see org.apache.struts.chain.commands.AbstractRequestNoCache
     * #requestNoCache(org.apache.struts.chain.contexts.ActionContext)
     */
    @Override
    protected void requestNoCache(final ActionContext<String, Object> context) {
        ServletActionContext sacontext = (ServletActionContext) context;
        HttpServletResponse response = sacontext.getResponse();
        response.setHeader("Pragma", "No-cache");
        response.setHeader("Cache-Control", "no-cache,no-store,max-age=0");
        response.setDateHeader("Expires", 1);
    }
}
