/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.commons.chain2.base;

import org.apache.commons.chain2.Context;
import org.apache.commons.chain2.impl.TestContext;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

/**
 * @version $Id$
 */
public class RemoveCommandTestCase {

    /** RemoveCommand */
    private RemoveCommand<String, Object, Context<String, Object>> command = null;
    /** Context */
    private Context<String, Object> context = null;

    /**
     * Setup
     */
    @Before
    public void setUp() {
        this.command = new RemoveCommand<>();
        this.context = new TestContext();

        this.context.put("Key", "Value");
        this.context.put("another Key", "another Value");
    }

    /**
     * nonExistingKeyDoesNotAlterContext
     */
    @Test
    public void nonExistingKeyDoesNotAlterContext() {
        this.command.setFromKey("yet another Key");
        this.command.execute(this.context);

        Assert.assertTrue(this.context.containsKey("Key"));
        Assert.assertTrue(this.context.containsKey("another Key"));
    }

    /**
     * existingKeyIsRemoved
     */
    @Test
    public void existingKeyIsRemoved() {
        this.command.setFromKey("Key");
        this.command.execute(this.context);

        Assert.assertFalse(this.context.containsKey("Key"));
        Assert.assertTrue(this.context.containsKey("another Key"));
    }

}
