/*
 * $Id: TestActionMessage.java 471754 2006-11-06 14:55:09Z husted $
 *
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.struts.action;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

/**
 * Unit tests for the <code>org.apache.struts.action.ActionMessage</code>
 * class.
 *
 * @version $Rev: 471754 $ $Date: 2005-05-19 23:50:06 -0400 (Thu, 19 May 2005)
 *          $
 */
public class TestActionMessage extends TestCase {
    protected ActionMessage amWithNoValue = null;
    protected ActionMessage amWithOneValue = null;
    protected ActionMessage amWithTwoValues = null;
    protected ActionMessage amWithThreeValues = null;
    protected ActionMessage amWithFourValues = null;
    protected ActionMessage amWithArrayValues = null;
    protected ActionMessage amWithTwoIntegerValues = null;
    protected ActionMessage amNoResource = null;
    protected Object[] test_values =
        new Object[] {
            "stringValue1", "stringValue2", "stringValue3", "stringValue4"
        };

    /**
     * Defines the testcase name for JUnit.
     *
     * @param theName the testcase's name.
     */
    public TestActionMessage(String theName) {
        super(theName);
    }

    /**
     * Start the tests.
     *
     * @param theArgs the arguments. Not used
     */
    public static void main(String[] theArgs) {
        junit.textui.TestRunner.main(new String[] {
                TestActionMessage.class.getName()
            });
    }

    /**
     * @return a test suite (<code>TestSuite</code>) that includes all methods
     *         starting with "test"
     */
    public static Test suite() {
        // All methods starting with "test" will be executed in the test suite.
        return new TestSuite(TestActionMessage.class);
    }
    /** @see junit.framework.TestCase#setUp() */
    @Override public void setUp() {
        amWithNoValue = new ActionMessage("amWithNoValue");
        amWithOneValue =
            new ActionMessage("amWithOneValue", "stringValue");
        amWithTwoValues =
            new ActionMessage("amWithTwoValues", "stringValue1",
                "stringValue2");
        amWithThreeValues =
            new ActionMessage("amWithThreeValues", "stringValue1",
                "stringValue2", "stringValue3");
        amWithFourValues =
            new ActionMessage("amWithFourValues", "stringValue1",
                "stringValue2", "stringValue3",
                "stringValue4");
        amWithArrayValues = new ActionMessage("amWithArrayValues", test_values);
        amWithTwoIntegerValues =
            new ActionMessage("amWithTwoIntegerValues", Integer.valueOf(5),
                Integer.valueOf(10));
        amNoResource = new ActionMessage("amNoResource", false);
    }
    /** @see junit.framework.TestCase#tearDown() */
    @Override public void tearDown() {
        amWithNoValue = null;
        amWithOneValue = null;
        amWithTwoValues = null;
        amWithThreeValues = null;
        amWithFourValues = null;
        amWithArrayValues = null;
        amWithTwoIntegerValues = null;
        amNoResource = null;
    }
    /** testActionMessageWithNoValue */
    public void testActionMessageWithNoValue() {
//        assertTrue(amWithNoValue.getValues() == null);
        assertTrue(amWithNoValue.getValues().length == 0);
        assertTrue(amWithNoValue.isResource());
        assertTrue(amWithNoValue.getKey() == "amWithNoValue");
        assertTrue(amWithNoValue.toString().equals("amWithNoValue[]"));
    }
    /** testActionMessageWithAStringValue */
    public void testActionMessageWithAStringValue() {
        Object[] values = amWithOneValue.getValues();

        assertNotNull(values);
        assertTrue(values.length == 1);
        assertTrue(values[0].equals("stringValue"));
        assertTrue(amWithOneValue.isResource());
        assertTrue(amWithOneValue.getKey() == "amWithOneValue");
        assertTrue(amWithOneValue.toString().equals("amWithOneValue[stringValue]"));
    }
    /** testActionMessageWithTwoValues */
    public void testActionMessageWithTwoValues() {
        Object[] values = amWithTwoValues.getValues();

        assertNotNull(values);
        assertTrue(values.length == 2);
        assertTrue(values[0].equals("stringValue1"));
        assertTrue(values[1].equals("stringValue2"));
        assertTrue(amWithTwoValues.isResource());
        assertTrue(amWithTwoValues.getKey() == "amWithTwoValues");
        assertTrue(amWithTwoValues.toString().equals("amWithTwoValues[stringValue1, stringValue2]"));
    }
    /** testActionMessageWithThreeValues */
    public void testActionMessageWithThreeValues() {
        Object[] values = amWithThreeValues.getValues();

        assertNotNull(values);
        assertTrue(values.length == 3);
        assertTrue(values[0].equals("stringValue1"));
        assertTrue(values[1].equals("stringValue2"));
        assertTrue(values[2].equals("stringValue3"));
        assertTrue(amWithThreeValues.getKey() == "amWithThreeValues");
        assertTrue(amWithThreeValues.isResource());
        assertTrue(amWithThreeValues.toString().equals("amWithThreeValues[stringValue1, stringValue2, stringValue3]"));
    }
    /** testActionMessageWithFourValues */
    public void testActionMessageWithFourValues() {
        Object[] values = amWithFourValues.getValues();

        assertNotNull(values);
        assertTrue(values.length == 4);
        assertTrue(values[0].equals("stringValue1"));
        assertTrue(values[1].equals("stringValue2"));
        assertTrue(values[2].equals("stringValue3"));
        assertTrue(values[3].equals("stringValue4"));
        assertTrue(amWithFourValues.isResource());
        assertTrue(amWithFourValues.getKey() == "amWithFourValues");
        assertTrue(amWithFourValues.toString().equals("amWithFourValues[stringValue1, stringValue2, stringValue3, stringValue4]"));
    }
    /** testActionMessageWithArrayValues */
    public void testActionMessageWithArrayValues() {
        Object[] values = amWithArrayValues.getValues();

        assertNotNull(values);
        assertTrue(values.length == test_values.length);

        for (int i = 0; i < values.length; i++) {
            assertTrue(values[i] == test_values[i]);
        }

        assertTrue(amWithArrayValues.isResource());
        assertTrue(amWithArrayValues.getKey() == "amWithArrayValues");
        assertTrue(amWithArrayValues.toString().equals("amWithArrayValues[stringValue1, stringValue2, stringValue3, stringValue4]"));
    }
    /** testActionWithTwoIntegers */
    public void testActionWithTwoIntegers() {
        Object[] values = amWithTwoIntegerValues.getValues();

        assertNotNull(values);
        assertTrue(values.length == 2);
        assertTrue(values[0] instanceof Integer);
        assertTrue(values[0].toString().equals("5"));
        assertTrue(values[1] instanceof Integer);
        assertTrue(values[1].toString().equals("10"));
        assertTrue(amWithTwoIntegerValues.isResource());
        assertTrue(amWithTwoIntegerValues.getKey() == "amWithTwoIntegerValues");
        assertTrue(amWithTwoIntegerValues.toString().equals("amWithTwoIntegerValues[5, 10]"));
    }
    /** testActionNoResource */
    public void testActionNoResource() {
//        assertTrue(amNoResource.getValues() == null);
        assertTrue(amNoResource.getValues().length == 0);
        assertTrue(amNoResource.isResource() == false);
        assertTrue(amNoResource.getKey() == "amNoResource");
        assertTrue(amNoResource.toString().equals("amNoResource[]"));
    }
}
