/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.commons.chain2.base;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

import org.apache.commons.chain2.Processing;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

/**
 * @version $Id$
 */
public class CopyCommandTestCase {

    private CopyCommand<String, Object, Map<String, Object>> command;
    private Map<String, Object> context = null;
    private Map<String, Object> originalContext;

    /**
     * Setup
     */
    @Before
    public void setUp() {
        command = new CopyCommand<>();

        context = new HashMap<>();
        context.put("one", "one");
        context.put("two", "two");
        context.put("three", "three");

        originalContext = Collections.unmodifiableMap(new HashMap<>(context));
    }

    /**
     * Teardown
     */
    @After
    public void tearDown() {
        command = null;
        context = null;
    }

    /**
     * executeWithEmptyContextReturnsFalse
     */
    @Test
    public void executeWithEmptyContextReturnsFalse() {
        context.clear();
        execute();
    }

    /**
     * noToKeyDoesNotAlterContext
     */
    @Test
    public void noToKeyDoesNotAlterContext() {
        command.setFromKey("one");
        execute();

        Assert.assertEquals(originalContext, context);
    }

    /**
     * noToFromKeyDoesNotAlterContext
     */
    @Test
    public void noToFromKeyDoesNotAlterContext() {
        command.setToKey("one");
        execute();

        Assert.assertEquals(originalContext, context);
    }

    /**
     * bothKeysExistsValueIsCopied
     */
    @Test
    public void bothKeysExistsValueIsCopied() {
        command.setFromKey("one");
        command.setToKey("two");

        execute();

        Assert.assertEquals("one", context.get("one"));
        Assert.assertEquals("two", context.get("two"));
        Assert.assertEquals("three", context.get("three"));
        Assert.assertEquals(3, context.size());
    }

    private void execute() {
        // make sure execute always returns continue
    	Assert.assertEquals(Processing.CONTINUE, command.execute(context));
    }

}
