/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.commons.chain2.web.servlet;


import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.Hashtable;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

import javax.servlet.Filter;
import javax.servlet.FilterRegistration;
import javax.servlet.FilterRegistration.Dynamic;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRegistration;
import javax.servlet.SessionCookieConfig;
import javax.servlet.SessionTrackingMode;
import javax.servlet.descriptor.JspConfigDescriptor;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;


/**
 * Mock Object for ServletContext (Version 2.3)
 */
public class MockServletContext implements ServletContext {


    private Log log = LogFactory.getLog(MockServletContext.class);
    private Hashtable<String, Object> attributes = new Hashtable<>();
    private Hashtable<String, String> parameters = new Hashtable<>();


    // --------------------------------------------------------- Public Methods

    /**
     * @param name String
     * @param value String
     */
    public void addInitParameter(String name, String value) {
        parameters.put(name, value);
    }


    // ------------------------------------------------- ServletContext Methods

    /**
     * @see javax.servlet.ServletContext#getAttribute(java.lang.String)
     */
    @Override public Object getAttribute(String name) {
        return (attributes.get(name));
    }

    /**
     * @see javax.servlet.ServletContext#getAttributeNames()
     */
    @Override public Enumeration<String> getAttributeNames() {
        return (attributes.keys());
    }

    /**
     * @see javax.servlet.ServletContext#getContext(java.lang.String)
     */
    @Override public ServletContext getContext(String uripath) {
        throw new UnsupportedOperationException();
    }

    /**
     * @see javax.servlet.ServletContext#getInitParameter(java.lang.String)
     */
    @Override public String getInitParameter(String name) {
        return (Objects.toString(parameters.get(name), null));
    }

    /**
     * @see javax.servlet.ServletContext#getInitParameterNames()
     */
    @Override public Enumeration<String> getInitParameterNames() {
        return (parameters.keys());
    }

    /**
     * @see javax.servlet.ServletContext#getMajorVersion()
     */
    @Override public int getMajorVersion() {
        return (2);
    }

    /**
     * @see javax.servlet.ServletContext#getMimeType(java.lang.String)
     */
    @Override public String getMimeType(String path) {
        throw new UnsupportedOperationException();
    }

    /**
     * @see javax.servlet.ServletContext#getMinorVersion()
     */
    @Override public int getMinorVersion() {
        return (3);
    }

    /**
     * @see javax.servlet.ServletContext#getNamedDispatcher(java.lang.String)
     */
    @Override public RequestDispatcher getNamedDispatcher(String name) {
        throw new UnsupportedOperationException();
    }

    /**
     * @see javax.servlet.ServletContext#getRealPath(java.lang.String)
     */
    @Override public String getRealPath(String path) {
        throw new UnsupportedOperationException();
    }

    /**
     * @see javax.servlet.ServletContext#getRequestDispatcher(java.lang.String)
     */
    @Override public RequestDispatcher getRequestDispatcher(String path) {
        throw new UnsupportedOperationException();
    }

    /**
     * @see javax.servlet.ServletContext#getResource(java.lang.String)
     */
    @Override public URL getResource(String path) throws MalformedURLException {
        throw new UnsupportedOperationException();
    }

    /**
     * @see javax.servlet.ServletContext#getResourceAsStream(java.lang.String)
     */
    @Override public InputStream getResourceAsStream(String path) {
        throw new UnsupportedOperationException();
    }

    /**
     * @see javax.servlet.ServletContext#getResourcePaths(java.lang.String)
     */
    @Override public Set<String> getResourcePaths(String path) {
        throw new UnsupportedOperationException();
    }

    /**
     * @deprecated deprecated
     */
    @Deprecated
    @Override public Servlet getServlet(String name) throws ServletException {
        throw new UnsupportedOperationException();
    }

    /**
     * @see javax.servlet.ServletContext#getServletContextName()
     */
    @Override public String getServletContextName() {
        return ("MockServletContext");
    }

    /**
     * @see javax.servlet.ServletContext#getServerInfo()
     */
    @Override public String getServerInfo() {
        return ("MockServletContext");
    }

    /**
     * @deprecated deprecated
     */
    @Deprecated
    @Override public Enumeration<Servlet> getServlets() {
        throw new UnsupportedOperationException();
    }

    /**
     * @deprecated deprecated
     */
    @Deprecated
    @Override public Enumeration<String> getServletNames() {
        throw new UnsupportedOperationException();
    }

    /**
     * @see javax.servlet.ServletContext#log(java.lang.String)
     */
    @Override public void log(String message) {
        log.info(message);
    }

    /**
     * @deprecated deprecated
     */
    @Deprecated
    @Override public void log(Exception exception, String message) {
        log.error(message, exception);
    }

    /**
     * @see javax.servlet.ServletContext#log(java.lang.String, java.lang.Throwable)
     */
    @Override public void log(String message, Throwable exception) {
        log.error(message, exception);
    }

    /**
     * @see javax.servlet.ServletContext#removeAttribute(java.lang.String)
     */
    @Override public void removeAttribute(String name) {
        attributes.remove(name);
    }

    /**
     * @see javax.servlet.ServletContext#setAttribute(java.lang.String, java.lang.Object)
     */
    @Override public void setAttribute(String name, Object value) {
        attributes.put(name, value);
    }

    /**
     * @see javax.servlet.ServletContext#getContextPath()
     */
    @Override public String getContextPath() {
        throw new UnsupportedOperationException("Not supported yet.");
    }


    /**
     * @see javax.servlet.ServletContext#addFilter(java.lang.String, java.lang.String)
     */
    @Override
    public Dynamic addFilter(String arg0, String arg1) {
        return null;
    }


    /**
     * @see javax.servlet.ServletContext#addFilter(java.lang.String, javax.servlet.Filter)
     */
    @Override
    public Dynamic addFilter(String arg0, Filter arg1) {
        return null;
    }


    /**
     * @see javax.servlet.ServletContext#addFilter(java.lang.String, java.lang.Class)
     */
    @Override
    public Dynamic addFilter(String arg0, Class<? extends Filter> arg1) {
        return null;
    }


    /**
     * @see javax.servlet.ServletContext#addListener(java.lang.String)
     */
    @Override
    public void addListener(String arg0) {
        return;
    }


    /**
     * @see javax.servlet.ServletContext#addListener(java.util.EventListener)
     */
    @Override
    public <T extends EventListener> void addListener(T arg0) {
        return;
    }


    /**
     * @see javax.servlet.ServletContext#addListener(java.lang.Class)
     */
    @Override
    public void addListener(Class<? extends EventListener> arg0) {
        return;
    }


    /**
     * @see javax.servlet.ServletContext#addServlet(java.lang.String, java.lang.String)
     */
    @Override
    public javax.servlet.ServletRegistration.Dynamic addServlet(String arg0,
            String arg1) {
        return null;
    }


    /**
     * @see javax.servlet.ServletContext#addServlet(java.lang.String, javax.servlet.Servlet)
     */
    @Override
    public javax.servlet.ServletRegistration.Dynamic addServlet(String arg0,
            Servlet arg1) {
        return null;
    }


    /**
     * @see javax.servlet.ServletContext#addServlet(java.lang.String, java.lang.Class)
     */
    @Override
    public javax.servlet.ServletRegistration.Dynamic addServlet(String arg0,
            Class<? extends Servlet> arg1) {
        return null;
    }

    /**
     * @see javax.servlet.ServletContext#createFilter(java.lang.Class)
     */
    @Override
    public <T extends Filter> T createFilter(Class<T> arg0)
            throws ServletException {
        return null;
    }

    /**
     * @see javax.servlet.ServletContext#createListener(java.lang.Class)
     */
    @Override
    public <T extends EventListener> T createListener(Class<T> arg0)
            throws ServletException {
        return null;
    }

    /**
     * @see javax.servlet.ServletContext#createServlet(java.lang.Class)
     */
    @Override
    public <T extends Servlet> T createServlet(Class<T> arg0)
            throws ServletException {
        return null;
    }

    /**
     * @see javax.servlet.ServletContext#declareRoles(java.lang.String[])
     */
    @Override
    public void declareRoles(String... arg0) {
        return;
    }

    /**
     * @see javax.servlet.ServletContext#getClassLoader()
     */
    @Override
    public ClassLoader getClassLoader() {
        return null;
    }

    /**
     * @see javax.servlet.ServletContext#getDefaultSessionTrackingModes()
     */
    @Override
    public Set<SessionTrackingMode> getDefaultSessionTrackingModes() {
        return null;
    }

    /**
     * @see javax.servlet.ServletContext#getEffectiveMajorVersion()
     */
    @Override
    public int getEffectiveMajorVersion() {
        return 0;
    }

    /**
     * @see javax.servlet.ServletContext#getEffectiveMinorVersion()
     */
    @Override
    public int getEffectiveMinorVersion() {
        return 0;
    }

    /**
     * @see javax.servlet.ServletContext#getEffectiveSessionTrackingModes()
     */
    @Override
    public Set<SessionTrackingMode> getEffectiveSessionTrackingModes() {
        return null;
    }

    /**
     * @see javax.servlet.ServletContext#getFilterRegistration(java.lang.String)
     */
    @Override
    public FilterRegistration getFilterRegistration(String arg0) {
        return null;
    }

    /**
     * @see javax.servlet.ServletContext#getFilterRegistrations()
     */
    @Override
    public Map<String, ? extends FilterRegistration> getFilterRegistrations() {
        return null;
    }

    /**
     * @see javax.servlet.ServletContext#getJspConfigDescriptor()
     */
    @Override
    public JspConfigDescriptor getJspConfigDescriptor() {
        return null;
    }

    /**
     * @see javax.servlet.ServletContext#getServletRegistration(java.lang.String)
     */
    @Override
    public ServletRegistration getServletRegistration(String arg0) {
        return null;
    }

    /**
     * @see javax.servlet.ServletContext#getServletRegistrations()
     */
    @Override
    public Map<String, ? extends ServletRegistration> getServletRegistrations() {
        return null;
    }

    /**
     * @see javax.servlet.ServletContext#getSessionCookieConfig()
     */
    @Override
    public SessionCookieConfig getSessionCookieConfig() {
        return null;
    }

    /**
     * @see javax.servlet.ServletContext#setInitParameter(java.lang.String, java.lang.String)
     */
    @Override
    public boolean setInitParameter(String arg0, String arg1) {
        return false;
    }

    /**
     * @see javax.servlet.ServletContext#setSessionTrackingModes(java.util.Set)
     */
    @Override
    public void setSessionTrackingModes(Set<SessionTrackingMode> arg0)
            throws IllegalStateException, IllegalArgumentException {
        return;
    }

    /**
     * @see javax.servlet.ServletContext#getVirtualServerName()
     */
    @Override
    public String getVirtualServerName() {
        return null;
    }

}
