/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.commons.chain2.web.servlet;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.chain2.web.WebContext;

/**
 * @since 1.0.0
 * @version $Id$
 * @param <K> K
 * @param <V> V
 */
public interface ServletWebContext<K, V> extends WebContext<K, V> {
    /**
     * <p>Return the {@link javax.servlet.ServletContext} for this context.</p>
     *
     * @return The <code>ServletContext</code> for this context.
     */
    ServletContext getContext();

    /**
     * <p>Return the {@link javax.servlet.http.HttpServletRequest} for this context.</p>
     *                     ServletWebContextBase
     * @return The <code>HttpServletRequest</code> for this context.
     */
    HttpServletRequest getRequest();

    /**
     * <p>Return the {@link javax.servlet.http.HttpServletResponse} for this context.</p>
     *
     * @return The <code>HttpServletResponse</code> for this context.
     */
    HttpServletResponse getResponse();

    /**
     * <p>Initialize (or reinitialize) this {@link ServletWebContext} instance
     * for the specified Servlet API objects.</p>
     *
     * @param context The <code>ServletContext</code> for this web application
     * @param request The <code>HttpServletRequest</code> for this request
     * @param response The <code>HttpServletResponse</code> for this request
     */
    void initialize(ServletContext context,
                    HttpServletRequest request,
                    HttpServletResponse response);

    /**
     * <p>Release references to allocated resources acquired in
     * <code>initialize()</code> of via subsequent processing.  After this
     * method is called, subsequent calls to any other method than
     * <code>initialize()</code> will return undefined results.</p>
     */
    void release();

}
