package project.common;

import org.junit.Assert;
import org.junit.Test;

/**
 * TestSringUtil
 *
 */
public class TestSringUtil {

	/**
	 * 先頭ゼロサプレス
	 */
	@Test
	public void suppressZeroTest1() {
		Assert.assertEquals("1", StringUtil.suppressZero("0001"));
	}

	/**
	 * 先頭ゼロサプレス小数点あり
	 */
	@Test
	public void suppressZeroTest2() {
		Assert.assertEquals("1.123", StringUtil.suppressZero("0001.123"));
	}


	/**
	 * 左トリム
	 */
	@Test
	public void trimLeftTest1() {
		Assert.assertEquals("1", StringUtil.trimLeft("0001", '0'));
	}


	/**
	 * 右トリム
	 */
	@Test
	public void trimRightTest1() {
		Assert.assertEquals("000", StringUtil.trimRight("0001", '1'));
	}


	/**
	 * 指定文字列挿入空文字
	 */
	@Test
	public void infixTest1() {
		Assert.assertEquals("", StringUtil.infix("", "-", 1, 2));
	}

	/**
	 * 指定文字列挿入一文字
	 */
	@Test
	public void infixTest2() {
		Assert.assertEquals("A", StringUtil.infix("A", "-", 1, 2));
	}

	/**
	 * 指定文字列挿入２文字
	 */
	@Test
	public void infixTest3() {
		Assert.assertEquals("A-B", StringUtil.infix("AB", "-", 1));
	}

	/**
	 * 指定文字列挿入２文字右から
	 */
	@Test
	public void infixTest4() {
		Assert.assertEquals("A-B", StringUtil.infix("AB", "-", -1));
	}

	/**
	 * 指定文字列挿入７文字左右から７以下指定
	 */
	@Test
	public void infixTest5() {
		Assert.assertEquals("AB-C-D-EF-G", StringUtil.infix("ABCDEFG", "-", -1, 2, 3, -3));
	}

	/**
	 * 指定文字列挿入７文字左右から７以上指定あり時
	 */
	@Test
	public void infixTest6() {
		Assert.assertEquals("AB-CDEF-G", StringUtil.infix("ABCDEFG", "-", -1, 2, 13, -9));
	}
}
