package project.web.processor;

import online.context.session.SessionScope;
import online.context.session.SessionUser;
import online.struts.action.UniForm;

import org.apache.commons.chain2.Processing;
import org.apache.struts.action.ActionForm;
import org.apache.struts.chain.commands.ActionCommandBase;
import org.apache.struts.chain.contexts.ActionContext;
import org.apache.struts.chain.contexts.ServletActionContext;

/**
 * ダミーUID設定プロセッサ
 *
 * @author Tadashi Nakayama
 * @version 1.0.0
 */
public final class DummyUIDProcessor implements ActionCommandBase {

	/** ダミー用ユーザID */
	private static final String DUMMY_UID = "9999999999";

	/**
	 * @see org.apache.struts.chain.commands.ActionCommandBase
	 * #execute(org.apache.struts.chain.contexts.ActionContext)
	 */
	@Override
	public Processing execute(final ActionContext<String, Object> context) {

		if (ServletActionContext.class.isInstance(context)) {
			final ServletActionContext sac = ServletActionContext.class.cast(context);
			if (SessionScope.getSessionUser(sac.getRequest()) == null) {
				final SessionUser m = new SessionUser(DUMMY_UID);
				SessionScope.setSessionUser(sac.getRequest(), m);
				final ActionForm form = context.getActionForm();
				if (UniForm.class.isInstance(form)) {
					UniForm.class.cast(form).setSessionUser(m);
				}
			}
		}

		return Processing.CONTINUE;
	}
}
