package project.web.job;

import java.util.Objects;

import batch.controller.JobRequestor;
import batch.status.Job;
import batch.status.JobStatus;
import common.db.JdbcSource;
import common.db.jdbc.Jdbc;
import core.config.Factory;
import online.context.check.InputCheck;
import online.context.session.SessionUser;
import online.struts.action.BrowseAction;
import online.struts.action.UniForm;
import project.check.attribute.LongNumeralCheck;
import project.check.existence.MustCheck;
import project.web.InstanceFactory;
import project.web.generic.SearchAction;

/**
 * バッチ状況照会画面
 *
 * @author Tadashi Nakayama
 * @version 1.0.0
 */
public final class StatusAction implements BrowseAction {

	/** JobSeq */
	private static final String JOB_SEQ = "JobSeq";

	/** クエリ */
	private String query = null;

	/**
	 * クエリ設定
	 *
	 * @param qry クエリファイル
	 */
	public void setQueryFile(final String qry) {
		this.query = qry;
	}

	/**
	 * 表示処理
	 *
	 * @param model 汎用データモデル
	 * @return 処理結果
	 */
	public String get(final UniForm model) {
		final SearchAction action = new SearchAction();
		action.setQueryFile(this.query);
		return action.get(model);
	}

	/**
	 * バッチ中止処理
	 *
	 * @param model 汎用モデル
	 * @return 処理結果
	 */
	public String cancel(final UniForm model) {

		final InputCheck ic = InstanceFactory.create(InputCheck.class, model);
		ic.add(JOB_SEQ, new MustCheck());
		ic.add(JOB_SEQ, new LongNumeralCheck());
		ic.populate();

		try (Jdbc conn = JdbcSource.getConnection()) {
			final JobStatus js = Factory.create(JobStatus.class);
			final Job job = js.getJob(conn, model.getNumber(JOB_SEQ).longValue());

			final SessionUser su = model.getSessionUser();
			if (Objects.equals(job.getUid(), su.getUid())) {
				// 中止処理呼出
				JobRequestor.cancelJob(model.getNumber(JOB_SEQ).longValue());
			}
		}
		return ID_OK;
	}
}
