package project.view.tag;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;

import javax.servlet.jsp.JspException;

import online.view.ViewUtil;
import online.view.tag.BaseTag;
import project.master.CodeKeeper;
import project.master.CodeKeeper.Code;
import project.view.LabelValue;
import core.config.Factory;

/**
 * コードタグライブラリ
 *
 * @author Tadashi Nakayama
 * @version 1.0.0
 */
public final class CodeTag extends BaseTag {
	/** serialVersion */
	private static final long serialVersionUID = 586098353606769650L;

	/** 変数用変数 */
	private String var = null;
	/** コード種別 */
	private String codesbt = null;
	/** コード */
	private String code = null;

	/**
	 * リリース処理
	 */
	@Override
	public void release() {
		this.var = null;
		this.codesbt = null;
		this.code = null;
	}

	/**
	 * 変数設定
	 *
	 * @param val 保存変数名文字列
	 */
	public void setVar(final String val) {
		this.var = val;
	}

	/**
	 * コード種別
	 * @param val コード種別
	 */
	public void setCodeSbt(final String val) {
		this.codesbt = val;
	}

	/**
	 * コード
	 * @param val コード
	 */
	public void setCode(final String val) {
		this.code = val;
	}

	/**
	 * @see javax.servlet.jsp.tagext.TagSupport#doStartTag()
	 */
	@Override
	public int doStartTag() throws JspException {
		try {
			doTag();
			return SKIP_BODY;
		} finally {
			release();
		}
	}

	/**
	 * タグ処理
	 */
	public void doTag() {
		if (this.var != null) {
			this.pageContext.removeAttribute(this.var);
		}

		final CodeKeeper ck = Factory.create(CodeKeeper.class);
		if (ck == null || this.codesbt == null) {
			return;
		}

		if (this.code != null) {
			final Code t = ck.getCode(this.codesbt, this.code);
			if (t != null) {
				super.output(this.var, t.getName());
			}
		} else {
			final List<Code> list = ck.getCodeList(this.codesbt);
			if (list != null) {
				// 項目選択設定
				this.pageContext.setAttribute(this.var, toLabelValue(list));
			}
		}
	}

	/**
	 * リスト作成
	 * @param tl リスト
	 * @return リスト
	 */
	private List<LabelValue> toLabelValue(final List<Code> tl) {
		final Charset cs = ViewUtil.getCharset(super.getResponse());
		final List<LabelValue> ret = new ArrayList<>();
		for (final Code t : tl) {
			final String lbl = ViewUtil.sanitize(t.getNameOption(), cs, true);
			final String val = ViewUtil.sanitize(t.getCode(), cs, true);
			final String cmt = ViewUtil.sanitize(t.getTxComment(), cs, true);
			ret.add(new LabelValue(lbl, val, cmt));
		}
		return ret;
	}
}
