package online.struts.chain.processor;

import online.filter.FilterUtil;

import org.apache.commons.chain2.Processing;
import org.apache.struts.chain.commands.servlet.ExceptionHandler;
import org.apache.struts.chain.contexts.ActionContext;
import org.apache.struts.chain.contexts.ServletActionContext;
import org.apache.struts.config.ForwardConfig;

/**
 * 例外ハンドル
 *
 * @author Tadashi Nakayama
 */
public final class HandleThrowableProcessor extends ExceptionHandler {

	/**
	 * @see org.apache.struts.chain.commands.AbstractExceptionHandler
	 * #execute(org.apache.struts.chain.contexts.ActionContext)
	 */
	@Override
	public Processing execute(final ActionContext<String, Object> actionCtx) {
		final Processing ret = super.execute(actionCtx);
		if (Processing.CONTINUE.equals(ret) && ServletActionContext.class.isInstance(actionCtx)) {
			final ServletActionContext sac = ServletActionContext.class.cast(actionCtx);
			final ForwardConfig fc = actionCtx.getForwardConfig();
			if (fc != null && FilterUtil.isInclude(sac.getRequest())) {
				if (sac.getInclude() == null) {
					sac.setInclude(fc.getPath());
				}
				sac.getResponse().reset();
				sac.getResponse().resetBuffer();
				sac.setForwardConfig(null);
			}
		}
		return ret;
	}
}
