package project.base;

import java.sql.Timestamp;
import java.util.Map;

import core.util.DateUtil;
import online.context.session.SessionUser;

/**
 * 業務ロジック作成用親
 *
 * @author Tadashi Nakayama
 * @version 1.0.0
 */
public abstract class ServiceAbstract {

	/** ユーザ情報 */
	private SessionUser su = null;
	/** 共通プロパティ */
	private Map<String, String> common = null;
	/** IP */
	private String ip = null;
	/** 現在日時 */
	private Timestamp dateTime = null;

	/**
	 * 現在日時取得
	 *
	 * @return 現在日時
	 */
	protected Timestamp getDateTime() {
		return DateUtil.copyOf(this.dateTime);
	}

	/**
	 * 現在日時設定
	 *
	 * @param val 現在日時
	 */
	public void setDateTime(final Timestamp val) {
		this.dateTime = DateUtil.copyOf(val);
	}

	/**
	 * IPアドレス取得
	 *
	 * @return IPアドレス
	 */
	protected String getIp() {
		return this.ip;
	}

	/**
	 * IPアドレス設定
	 *
	 * @param val IPアドレス
	 */
	public void setIp(final String val) {
		this.ip = val;
	}

	/**
	 * ユーザID取得
	 *
	 * @return ユーザID
	 */
	protected String getUid() {
		if (this.su != null) {
			return this.su.getUid();
		}
		return null;
	}

	/**
	 * ユーザID設定
	 *
	 * @param val ユーザID
	 */
	public void setSessionUser(final SessionUser val) {
		this.su = val;
	}

	/**
	 * ユーザ情報取得
	 * @return ユーザ情報
	 */
	protected SessionUser getSessionUser() {
		return this.su;
	}

	/**
	 * 共通プロパティ設定
	 * @param val 共通プロパティ
	 */
	public void setProperty(final Map<String, String> val) {
		this.common = val;
	}

	/**
	 * 共通プロパティ取得
	 * @return 共通プロパティ
	 */
	protected Map<String, String> getProperty() {
		return this.common;
	}
}
