package online.view.tag;

import javax.servlet.jsp.JspException;

/**
 * キャッシュ制御タグライブラリ
 *
 * @author Tadashi Nakayama
 * @version 1.0.0
 */
public class NoCacheTag extends BaseTag {
	/** serialVersionUID */
	private static final long serialVersionUID = 738648270798951915L;

	/**
	 * @see javax.servlet.jsp.tagext.TagSupport#doStartTag()
	 */
	@Override
	public int doStartTag() throws JspException {
		super.getResponse().setHeader("Pragma", "No-cache");
		super.getResponse().setHeader("Cache-Control", "no-cache,no-store,max-age=0");
		super.getResponse().setDateHeader("Expires", 1);
		return SKIP_BODY;
	}
}
