package online.model;

import org.junit.Assert;
import org.junit.Test;

import test.AssertUtil;

/**
 * TestUniModel
 *
 */
public class TestUniModel {

	/**
	 * testNoValue1
	 */
	@Test
	public void testNoValue1() {
		final UniModelImpl um = new UniModelImpl();
		um.noValue("AAAAA");

		Assert.assertNull(um.getValueClass("AAAAA"));
		Assert.assertTrue(um.containsKey("AAAAA"));
		Assert.assertFalse(um.hasValue("AAAAA"));
		Assert.assertEquals("", um.getString("AAAAA"));
		Assert.assertEquals(0, um.getArraySize("AAAAA"));
		Assert.assertEquals(0, um.getStringArray("AAAAA").length);
		Assert.assertFalse(um.isArrayValue("AAAAA"));

		um.addValue("AAAAA", "XXXXX");
		Assert.assertTrue(um.containsKey("AAAAA"));
		Assert.assertTrue(um.hasValue("AAAAA"));
		Assert.assertEquals("XXXXX", um.getString("AAAAA"));
		Assert.assertEquals(1, um.getArraySize("AAAAA"));
		Assert.assertEquals(1, um.getStringArray("AAAAA").length);
		Assert.assertFalse(um.isArrayValue("AAAAA"));
	}

	/**
	 * testNoValue2
	 */
	@Test
	public void testNoValue2() {
		final UniModelImpl um = new UniModelImpl();
		um.setValue("AAAAA", "XXXX");

		Assert.assertTrue(um.containsKey("AAAAA"));
		Assert.assertTrue(um.hasValue("AAAAA"));
		Assert.assertEquals("XXXX", um.getString("AAAAA"));
		Assert.assertEquals("XXXX", um.getStringArray("AAAAA")[0]);
		Assert.assertEquals(1, um.getArraySize("AAAAA"));
		Assert.assertEquals(1, um.getStringArray("AAAAA").length);
		Assert.assertFalse(um.isArrayValue("AAAAA"));

		um.noValue("AAAAA");
		Assert.assertNull(um.getValueClass("AAAAA"));
		Assert.assertTrue(um.containsKey("AAAAA"));
		Assert.assertFalse(um.hasValue("AAAAA"));
		Assert.assertEquals("", um.getString("AAAAA"));
		Assert.assertEquals(0, um.getArraySize("AAAAA"));
		Assert.assertEquals(0, um.getStringArray("AAAAA").length);
		Assert.assertFalse(um.isArrayValue("AAAAA"));

		um.addValue("AAAAA", "ZZZZZ");
		um.addValue("AAAAA", "YYYYY");
		Assert.assertTrue(um.containsKey("AAAAA"));
		Assert.assertTrue(um.hasValue("AAAAA"));
		Assert.assertEquals(2, um.getArraySize("AAAAA"));
		Assert.assertEquals(2, um.getStringArray("AAAAA").length);
		Assert.assertEquals("ZZZZZ", um.getStringArray("AAAAA")[0]);
		Assert.assertEquals("YYYYY", um.getStringArray("AAAAA")[1]);
		Assert.assertTrue(um.isArrayValue("AAAAA"));
	}


	/**
	 * testAliasKey0
	 */
	@Test
	public void testAliasKey0() {
		final UniModelImpl um = new UniModelImpl();
		um.noValue("BBBBB");
		um.aliasKey("BBBBB", "AAAAA");

		Assert.assertTrue(um.containsKey("BBBBB"));
		Assert.assertTrue(um.containsKey("AAAAA"));
		Assert.assertFalse(um.hasValue("AAAAA"));
		Assert.assertEquals("", um.getString("AAAAA"));
		Assert.assertEquals(0, um.getArraySize("AAAAA"));
		Assert.assertEquals(0, um.getStringArray("AAAAA").length);
		Assert.assertFalse(um.isArrayValue("AAAAA"));
	}

	/**
	 * testAliasKey1
	 */
	@Test
	public void testAliasKey1() {
		final UniModelImpl um = new UniModelImpl();
		um.setValue("bbbbb", (String)null);
		um.aliasKey("bbbbb", "aaaaa");

		Assert.assertTrue(um.containsKey("aaaaa"));
		Assert.assertFalse(um.hasValue("aaaaa"));
		Assert.assertEquals("", um.getString("aaaaa"));
		Assert.assertEquals(0, um.getArraySize("aaaaa"));
		Assert.assertEquals(0, um.getStringArray("aaaaa").length);
		Assert.assertFalse(um.isArrayValue("aaaaa"));
	}

	/**
	 * testAliasKey2
	 */
	@Test
	public void testAliasKey2() {
		final UniModelImpl um = new UniModelImpl();
		um.setValue("bbbbb", (String[])null);
		um.aliasKey("bbbbb", "aaaaa");

		Assert.assertTrue(um.containsKey("aaaaa"));
		Assert.assertFalse(um.hasValue("aaaaa"));
		Assert.assertEquals("", um.getString("aaaaa"));
		Assert.assertEquals(0, um.getArraySize("aaaaa"));
		Assert.assertEquals(0, um.getStringArray("aaaaa").length);
		Assert.assertTrue(um.isArrayValue("aaaaa"));
	}

	/**
	 * testAliasKey3
	 */
	@Test
	public void testAliasKey3() {
		final UniModelImpl um = new UniModelImpl();
		um.setValue("bbbbb", (String)null);
		um.addValue("bbbbb", (String)null);
		um.aliasKey("bbbbb", "aaaaa");

		Assert.assertTrue(um.containsKey("aaaaa"));
		Assert.assertTrue(um.hasValue("aaaaa"));
		Assert.assertEquals("", um.getString("aaaaa"));
		Assert.assertEquals(1, um.getArraySize("aaaaa"));
		Assert.assertFalse(um.isArrayValue("aaaaa"));
	}

	/**
	 * testAliasKey4
	 */
	@Test
	public void testAliasKey4() {
		final UniModelImpl um = new UniModelImpl();
		um.setValue("bbbbb", new String[]{null});
		um.aliasKey("bbbbb", "aaaaa");

		Assert.assertTrue(um.containsKey("aaaaa"));
		Assert.assertTrue(um.hasValue("aaaaa"));
		Assert.assertNull(um.getStringArray("aaaaa")[0]);
		Assert.assertEquals(1, um.getArraySize("aaaaa"));
		Assert.assertEquals(1, um.getStringArray("aaaaa").length);
		Assert.assertTrue(um.isArrayValue("aaaaa"));
	}

	/**
	 * testAliasKey5
	 */
	@Test
	public void testAliasKey5() {
		final UniModelImpl um = new UniModelImpl();
		um.addValue("bbbbb", (String)null);
		um.aliasKey("bbbbb", "aaaaa");

		Assert.assertTrue(um.containsKey("aaaaa"));
		Assert.assertTrue(um.hasValue("aaaaa"));
		Assert.assertNull(um.getStringArray("aaaaa")[0]);
		Assert.assertEquals(1, um.getArraySize("aaaaa"));
		Assert.assertEquals(1, um.getStringArray("aaaaa").length);
		Assert.assertFalse(um.isArrayValue("aaaaa"));

		um.addValue("aaaaa", (String)null);
		Assert.assertTrue(um.containsKey("aaaaa"));
		Assert.assertTrue(um.hasValue("aaaaa"));
		Assert.assertEquals(2, um.getArraySize("aaaaa"));
		Assert.assertEquals(2, um.getStringArray("aaaaa").length);
		Assert.assertNull(um.getStringArray("aaaaa")[1]);
		Assert.assertTrue(um.isArrayValue("aaaaa"));

		Assert.assertTrue(um.containsKey("bbbbb"));
		Assert.assertTrue(um.hasValue("bbbbb"));
		Assert.assertNull(um.getStringArray("bbbbb")[0]);
		Assert.assertEquals(1, um.getArraySize("bbbbb"));
		Assert.assertEquals(1, um.getStringArray("bbbbb").length);
		Assert.assertFalse(um.isArrayValue("bbbbb"));
	}

	/**
	 * testAliasKey6
	 */
	@Test
	public void testAliasKey6() {
		final UniModelImpl um = new UniModelImpl();
		um.setValue("bbbbb", (String[])null);
		um.addValue("bbbbb", (String)null);
		um.aliasKey("bbbbb", "aaaaa");

		Assert.assertTrue(um.containsKey("aaaaa"));
		Assert.assertTrue(um.hasValue("aaaaa"));
		Assert.assertEquals("", um.getString("aaaaa"));
		Assert.assertEquals(1, um.getArraySize("aaaaa"));
		Assert.assertEquals(1, um.getStringArray("aaaaa").length);
		Assert.assertFalse(um.isArrayValue("aaaaa"));
	}

	/**
	 * testAliasKey7
	 */
	@Test
	public void testAliasKey7() {
		final UniModelImpl um = new UniModelImpl();
		um.addValue("bbbbb", (String[])null);
		um.aliasKey("bbbbb", "aaaaa");

		Assert.assertTrue(um.containsKey("aaaaa"));
		Assert.assertTrue(um.hasValue("aaaaa"));
		Assert.assertNull(um.getStringArray("aaaaa")[0]);
		Assert.assertEquals(1, um.getArraySize("aaaaa"));
		Assert.assertEquals(1, um.getStringArray("aaaaa").length);
		Assert.assertTrue(um.isArrayValue("aaaaa"));

		um.addValue("aaaaa", new String[]{"1", "2"});
		Assert.assertTrue(um.containsKey("aaaaa"));
		Assert.assertTrue(um.hasValue("aaaaa"));
		Assert.assertEquals("1", um.getStringArray("aaaaa")[1]);
		Assert.assertEquals("2", um.getStringArray("aaaaa")[2]);
		Assert.assertEquals(3, um.getArraySize("aaaaa"));
		Assert.assertEquals(3, um.getStringArray("aaaaa").length);
		Assert.assertTrue(um.isArrayValue("aaaaa"));

		Assert.assertTrue(um.containsKey("bbbbb"));
		Assert.assertTrue(um.hasValue("bbbbb"));
		Assert.assertNull(um.getStringArray("bbbbb")[0]);
		Assert.assertEquals(1, um.getArraySize("bbbbb"));
		Assert.assertEquals(1, um.getStringArray("bbbbb").length);
		Assert.assertTrue(um.isArrayValue("bbbbb"));
	}

	/**
	 * testAliasKey8
	 */
	@Test
	public void testAliasKey8() {
		final UniModelImpl um = new UniModelImpl();
		um.addValue("bbbbb", (String[])null);
		um.aliasKey("bbbbb", "aaaaa");

		Assert.assertTrue(um.containsKey("aaaaa"));
		Assert.assertTrue(um.hasValue("aaaaa"));
		Assert.assertNull(um.getStringArray("aaaaa")[0]);
		Assert.assertEquals(1, um.getArraySize("aaaaa"));
		Assert.assertEquals(1, um.getStringArray("aaaaa").length);
		Assert.assertTrue(um.isArrayValue("aaaaa"));

		um.addValue("aaaaa", (String)null);
		Assert.assertTrue(um.containsKey("aaaaa"));
		Assert.assertTrue(um.hasValue("aaaaa"));
		Assert.assertNull(um.getStringArray("aaaaa")[1]);
		Assert.assertEquals(2, um.getArraySize("aaaaa"));
		Assert.assertEquals(2, um.getStringArray("aaaaa").length);
		Assert.assertTrue(um.isArrayValue("aaaaa"));

		Assert.assertTrue(um.containsKey("bbbbb"));
		Assert.assertTrue(um.hasValue("bbbbb"));
		Assert.assertNull(um.getStringArray("bbbbb")[0]);
		Assert.assertEquals(1, um.getArraySize("bbbbb"));
		Assert.assertEquals(1, um.getStringArray("bbbbb").length);
		Assert.assertTrue(um.isArrayValue("bbbbb"));
	}


	/**
	 * testArraySize1
	 */
	@Test
	public void testArraySize1() {
		final UniModelImpl um = new UniModelImpl();
		um.setValue("aaaaa", (String)null);

		Assert.assertTrue(um.containsKey("aaaaa"));
		Assert.assertFalse(um.hasValue("aaaaa"));
		Assert.assertEquals("", um.getString("aaaaa"));
		Assert.assertEquals(0, um.getArraySize("aaaaa"));
		Assert.assertEquals(0, um.getStringArray("aaaaa").length);
		Assert.assertFalse(um.isArrayValue("aaaaa"));
	}

	/**
	 * testArraySize2
	 */
	@Test
	public void testArraySize2() {
		final UniModelImpl um = new UniModelImpl();
		um.setValue("aaaaa", (String[])null);

		Assert.assertTrue(um.containsKey("aaaaa"));
		Assert.assertFalse(um.hasValue("aaaaa"));
		Assert.assertEquals("", um.getString("aaaaa"));
		Assert.assertEquals(0, um.getArraySize("aaaaa"));
		Assert.assertEquals(0, um.getStringArray("aaaaa").length);
		Assert.assertTrue(um.isArrayValue("aaaaa"));
	}

	/**
	 * testArraySize3
	 */
	@Test
	public void testArraySize3() {
		final UniModelImpl um = new UniModelImpl();
		um.setValue("aaaaa", (String)null);
		um.addValue("aaaaa", (String)null);

		Assert.assertTrue(um.containsKey("aaaaa"));
		Assert.assertTrue(um.hasValue("aaaaa"));
		Assert.assertEquals("", um.getString("aaaaa"));
		Assert.assertEquals(1, um.getArraySize("aaaaa"));
		Assert.assertFalse(um.isArrayValue("aaaaa"));
	}

	/**
	 * testArraySize4
	 */
	@Test
	public void testArraySize4() {
		final UniModelImpl um = new UniModelImpl();
		um.setValue("aaaaa", new String[]{null});

		Assert.assertTrue(um.containsKey("aaaaa"));
		Assert.assertTrue(um.hasValue("aaaaa"));
		Assert.assertNull(um.getStringArray("aaaaa")[0]);
		Assert.assertEquals(1, um.getArraySize("aaaaa"));
		Assert.assertEquals(1, um.getStringArray("aaaaa").length);
		Assert.assertTrue(um.isArrayValue("aaaaa"));
	}

	/**
	 * testArraySize5
	 */
	@Test
	public void testArraySize5() {
		final UniModelImpl um = new UniModelImpl();
		um.addValue("aaaaa", (String)null);

		Assert.assertTrue(um.containsKey("aaaaa"));
		Assert.assertTrue(um.hasValue("aaaaa"));
		Assert.assertNull(um.getStringArray("aaaaa")[0]);
		Assert.assertEquals(1, um.getArraySize("aaaaa"));
		Assert.assertEquals(1, um.getStringArray("aaaaa").length);
		Assert.assertFalse(um.isArrayValue("aaaaa"));

		um.addValue("aaaaa", (String)null);
		Assert.assertTrue(um.containsKey("aaaaa"));
		Assert.assertTrue(um.hasValue("aaaaa"));
		Assert.assertNull(um.getStringArray("aaaaa")[1]);
		Assert.assertEquals(2, um.getArraySize("aaaaa"));
		Assert.assertEquals(2, um.getStringArray("aaaaa").length);
		Assert.assertTrue(um.isArrayValue("aaaaa"));
	}

	/**
	 * testArraySize6
	 */
	@Test
	public void testArraySize6() {
		final UniModelImpl um = new UniModelImpl();
		um.setValue("aaaaa", (String[])null);
		um.addValue("aaaaa", (String)null);

		Assert.assertTrue(um.containsKey("aaaaa"));
		Assert.assertTrue(um.hasValue("aaaaa"));
		Assert.assertEquals("", um.getString("aaaaa"));
		Assert.assertEquals(1, um.getArraySize("aaaaa"));
		Assert.assertEquals(1, um.getStringArray("aaaaa").length);
		Assert.assertFalse(um.isArrayValue("aaaaa"));
	}

	/**
	 * testArraySize7
	 */
	@Test
	public void testArraySize7() {
		final UniModelImpl um = new UniModelImpl();
		um.addValue("aaaaa", (String[])null);

		Assert.assertTrue(um.containsKey("aaaaa"));
		Assert.assertTrue(um.hasValue("aaaaa"));
		Assert.assertNull(um.getStringArray("aaaaa")[0]);
		Assert.assertEquals(1, um.getArraySize("aaaaa"));
		Assert.assertEquals(1, um.getStringArray("aaaaa").length);
		Assert.assertTrue(um.isArrayValue("aaaaa"));

		um.addValue("aaaaa", new String[]{"1", "2"});
		Assert.assertTrue(um.containsKey("aaaaa"));
		Assert.assertTrue(um.hasValue("aaaaa"));
		Assert.assertEquals("1", um.getStringArray("aaaaa")[1]);
		Assert.assertEquals("2", um.getStringArray("aaaaa")[2]);
		Assert.assertEquals(3, um.getArraySize("aaaaa"));
		Assert.assertEquals(3, um.getStringArray("aaaaa").length);
		Assert.assertTrue(um.isArrayValue("aaaaa"));
	}

	/**
	 * testArraySize8
	 */
	@Test
	public void testArraySize8() {
		final UniModelImpl um = new UniModelImpl();
		um.addValue("aaaaa", (String[])null);

		Assert.assertTrue(um.containsKey("aaaaa"));
		Assert.assertTrue(um.hasValue("aaaaa"));
		Assert.assertNull(um.getStringArray("aaaaa")[0]);
		Assert.assertEquals(1, um.getArraySize("aaaaa"));
		Assert.assertEquals(1, um.getStringArray("aaaaa").length);
		Assert.assertTrue(um.isArrayValue("aaaaa"));

		um.addValue("aaaaa", (String)null);
		Assert.assertTrue(um.containsKey("aaaaa"));
		Assert.assertTrue(um.hasValue("aaaaa"));
		Assert.assertNull(um.getStringArray("aaaaa")[1]);
		Assert.assertEquals(2, um.getArraySize("aaaaa"));
		Assert.assertEquals(2, um.getStringArray("aaaaa").length);
		Assert.assertTrue(um.isArrayValue("aaaaa"));
	}


	/**
	 * testArraySize8
	 */
	@Test
	public void testcopyValue0() {
		final UniModelImpl um = new UniModelImpl();
		um.noValue("aaaaa");

		final UniModelImpl um1 = new UniModelImpl();
		um.copyValueTo(um1, "aaaaa");

		AssertUtil.assertEquals(um.containsKey("aaaaa"), um1.containsKey("aaaaa"));
		AssertUtil.assertEquals(um.hasValue("aaaaa"), um1.hasValue("aaaaa"));
		Assert.assertEquals(um.getStringArray("aaaaa").length, um1.getStringArray("aaaaa").length);
		Assert.assertEquals(um.getString("aaaaa"), um1.getString("aaaaa"));
		Assert.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		AssertUtil.assertEquals(um.isArrayValue("aaaaa"), um1.isArrayValue("aaaaa"));
	}

	/**
	 * testcopyValue1
	 */
	@Test
	public void testcopyValue1() {
		final UniModelImpl um = new UniModelImpl();
		um.setValue("aaaaa", (String)null);

		final UniModelImpl um1 = new UniModelImpl();
		um.copyValueTo(um1, "aaaaa");

		AssertUtil.assertEquals(um.containsKey("aaaaa"), um1.containsKey("aaaaa"));
		AssertUtil.assertEquals(um.hasValue("aaaaa"), um1.hasValue("aaaaa"));
		Assert.assertEquals(um.getStringArray("aaaaa").length, um1.getStringArray("aaaaa").length);
		Assert.assertEquals(um.getString("aaaaa"), um1.getString("aaaaa"));
		Assert.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		AssertUtil.assertEquals(um.isArrayValue("aaaaa"), um1.isArrayValue("aaaaa"));
	}

	/**
	 * testcopyValue2
	 */
	@Test
	public void testcopyValue2() {
		final UniModelImpl um = new UniModelImpl();
		um.setValue("aaaaa", (String[])null);

		final UniModelImpl um1 = new UniModelImpl();
		um.copyValueTo(um1, "aaaaa");

		AssertUtil.assertEquals(um.containsKey("aaaaa"), um1.containsKey("aaaaa"));
		AssertUtil.assertEquals(um.hasValue("aaaaa"), um1.hasValue("aaaaa"));
		Assert.assertEquals(um.getStringArray("aaaaa").length, um1.getStringArray("aaaaa").length);
		Assert.assertEquals(um.getString("aaaaa"), um1.getString("aaaaa"));
		Assert.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		AssertUtil.assertEquals(um.isArrayValue("aaaaa"), um1.isArrayValue("aaaaa"));
	}

	/**
	 * testcopyValue3
	 */
	@Test
	public void testcopyValue3() {
		final UniModelImpl um = new UniModelImpl();
		um.setValue("aaaaa", (String)null);
		um.addValue("aaaaa", (String)null);

		final UniModelImpl um1 = new UniModelImpl();
		um.copyValueTo(um1, "aaaaa");

		AssertUtil.assertEquals(um.containsKey("aaaaa"), um1.containsKey("aaaaa"));
		AssertUtil.assertEquals(um.hasValue("aaaaa"), um1.hasValue("aaaaa"));
		Assert.assertEquals(um.getStringArray("aaaaa").length, um1.getStringArray("aaaaa").length);
		Assert.assertEquals(um.getString("aaaaa"), um1.getString("aaaaa"));
		Assert.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		AssertUtil.assertEquals(um.isArrayValue("aaaaa"), um1.isArrayValue("aaaaa"));
	}

	/**
	 * testcopyValue4
	 */
	@Test
	public void testcopyValue4() {
		final UniModelImpl um = new UniModelImpl();
		um.setValue("aaaaa", new String[]{null});

		final UniModelImpl um1 = new UniModelImpl();
		um.copyValueTo(um1, "aaaaa");

		AssertUtil.assertEquals(um.containsKey("aaaaa"), um1.containsKey("aaaaa"));
		AssertUtil.assertEquals(um.hasValue("aaaaa"), um1.hasValue("aaaaa"));
		Assert.assertEquals(um.getStringArray("aaaaa").length, um1.getStringArray("aaaaa").length);
		Assert.assertEquals(um.getString("aaaaa"), um1.getString("aaaaa"));
		Assert.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		AssertUtil.assertEquals(um.isArrayValue("aaaaa"), um1.isArrayValue("aaaaa"));
	}

	/**
	 * testcopyValue5
	 */
	@Test
	public void testcopyValue5() {
		final UniModelImpl um = new UniModelImpl();
		um.addValue("aaaaa", (String)null);

		final UniModelImpl um1 = new UniModelImpl();
		um.copyValueTo(um1, "aaaaa");

		AssertUtil.assertEquals(um.containsKey("aaaaa"), um1.containsKey("aaaaa"));
		AssertUtil.assertEquals(um.hasValue("aaaaa"), um1.hasValue("aaaaa"));
		Assert.assertEquals(um.getStringArray("aaaaa").length, um1.getStringArray("aaaaa").length);
		Assert.assertEquals(um.getString("aaaaa"), um1.getString("aaaaa"));
		Assert.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		AssertUtil.assertEquals(um.isArrayValue("aaaaa"), um1.isArrayValue("aaaaa"));

		um.addValue("aaaaa", (String)null);
		um.copyValueTo(um1, "aaaaa");

		AssertUtil.assertEquals(um.containsKey("aaaaa"), um1.containsKey("aaaaa"));
		AssertUtil.assertEquals(um.hasValue("aaaaa"), um1.hasValue("aaaaa"));
		Assert.assertEquals(um.getStringArray("aaaaa").length, um1.getStringArray("aaaaa").length);
		Assert.assertEquals(um.getStringArray("aaaaa")[1], um1.getStringArray("aaaaa")[1]);
		Assert.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		AssertUtil.assertEquals(um.isArrayValue("aaaaa"), um1.isArrayValue("aaaaa"));
	}

	/**
	 * testcopyValue6
	 */
	@Test
	public void testcopyValue6() {
		final UniModelImpl um = new UniModelImpl();
		um.setValue("aaaaa", (String[])null);
		um.addValue("aaaaa", (String)null);

		final UniModelImpl um1 = new UniModelImpl();
		um.copyValueTo(um1, "aaaaa");

		AssertUtil.assertEquals(um.containsKey("aaaaa"), um1.containsKey("aaaaa"));
		AssertUtil.assertEquals(um.hasValue("aaaaa"), um1.hasValue("aaaaa"));
		Assert.assertEquals(um.getStringArray("aaaaa").length, um1.getStringArray("aaaaa").length);
		Assert.assertEquals(um.getString("aaaaa"), um1.getString("aaaaa"));
		Assert.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		AssertUtil.assertEquals(um.isArrayValue("aaaaa"), um1.isArrayValue("aaaaa"));
	}

	/**
	 * testcopyValue7
	 */
	@Test
	public void testcopyValue7() {
		final UniModelImpl um = new UniModelImpl();
		um.addValue("aaaaa", (String[])null);

		final UniModelImpl um1 = new UniModelImpl();
		um.copyValueTo(um1, "aaaaa");

		AssertUtil.assertEquals(um.containsKey("aaaaa"), um1.containsKey("aaaaa"));
		AssertUtil.assertEquals(um.hasValue("aaaaa"), um1.hasValue("aaaaa"));
		Assert.assertEquals(um.getStringArray("aaaaa").length, um1.getStringArray("aaaaa").length);
		Assert.assertEquals(um.getString("aaaaa"), um1.getString("aaaaa"));
		Assert.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		AssertUtil.assertEquals(um.isArrayValue("aaaaa"), um1.isArrayValue("aaaaa"));

		um.addValue("aaaaa", new String[]{"1", "2"});
		um.copyValueTo(um1, "aaaaa");

		AssertUtil.assertEquals(um.containsKey("aaaaa"), um1.containsKey("aaaaa"));
		AssertUtil.assertEquals(um.hasValue("aaaaa"), um1.hasValue("aaaaa"));
		Assert.assertEquals(um.getStringArray("aaaaa").length, um1.getStringArray("aaaaa").length);
		Assert.assertEquals(um.getString("aaaaa"), um1.getString("aaaaa"));
		Assert.assertEquals(um.getStringArray("aaaaa")[1], um1.getStringArray("aaaaa")[1]);
		Assert.assertEquals(um.getStringArray("aaaaa")[2], um1.getStringArray("aaaaa")[2]);
		Assert.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		AssertUtil.assertEquals(um.isArrayValue("aaaaa"), um1.isArrayValue("aaaaa"));
	}

	/**
	 * testcopyValue8
	 */
	@Test
	public void testcopyValue8() {
		final UniModelImpl um = new UniModelImpl();
		um.addValue("aaaaa", (String[])null);

		final UniModelImpl um1 = new UniModelImpl();
		um.copyValueTo(um1, "aaaaa");

		AssertUtil.assertEquals(um.containsKey("aaaaa"), um1.containsKey("aaaaa"));
		AssertUtil.assertEquals(um.hasValue("aaaaa"), um1.hasValue("aaaaa"));
		Assert.assertEquals(um.getStringArray("aaaaa").length, um1.getStringArray("aaaaa").length);
		Assert.assertEquals(um.getString("aaaaa"), um1.getString("aaaaa"));
		Assert.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		AssertUtil.assertEquals(um.isArrayValue("aaaaa"), um1.isArrayValue("aaaaa"));

		um.addValue("aaaaa", (String)null);
		um.copyValueTo(um1, "aaaaa");

		AssertUtil.assertEquals(um.containsKey("aaaaa"), um1.containsKey("aaaaa"));
		AssertUtil.assertEquals(um.hasValue("aaaaa"), um1.hasValue("aaaaa"));
		Assert.assertEquals(um.getStringArray("aaaaa").length, um1.getStringArray("aaaaa").length);
		Assert.assertEquals(um.getString("aaaaa"), um1.getString("aaaaa"));
		Assert.assertEquals(um.getStringArray("aaaaa")[1], um1.getStringArray("aaaaa")[1]);
		Assert.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		AssertUtil.assertEquals(um.isArrayValue("aaaaa"), um1.isArrayValue("aaaaa"));
	}


	/**
	 * testputValue0
	 */
	@Test
	public void testputValue0() {
		final UniModelImpl um = new UniModelImpl();
		um.noValue("aaaaa");

		final UniModelImpl um1 = new UniModelImpl();
		um.putValueTo(um1, "aaaaa");

		AssertUtil.assertEquals(um.containsKey("aaaaa"), um1.containsKey("aaaaa"));
		AssertUtil.assertEquals(um.hasValue("aaaaa"), um1.hasValue("aaaaa"));
		Assert.assertEquals(um.getStringArray("aaaaa").length, um1.getStringArray("aaaaa").length);
		Assert.assertEquals(um.getString("aaaaa"), um1.getString("aaaaa"));
		Assert.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		AssertUtil.assertEquals(um.isArrayValue("aaaaa"), um1.isArrayValue("aaaaa"));
	}

	/**
	 * testputValue1
	 */
	@Test
	public void testputValue1() {
		final UniModelImpl um = new UniModelImpl();
		um.setValue("aaaaa", (String)null);

		final UniModelImpl um1 = new UniModelImpl();
		um.putValueTo(um1, "aaaaa");

		AssertUtil.assertEquals(um.containsKey("aaaaa"), um1.containsKey("aaaaa"));
		AssertUtil.assertEquals(um.hasValue("aaaaa"), um1.hasValue("aaaaa"));
		Assert.assertEquals(um.getStringArray("aaaaa").length, um1.getStringArray("aaaaa").length);
		Assert.assertEquals(um.getString("aaaaa"), um1.getString("aaaaa"));
		Assert.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		AssertUtil.assertEquals(um.isArrayValue("aaaaa"), um1.isArrayValue("aaaaa"));
	}

	/**
	 * testputValue2
	 */
	@Test
	public void testputValue2() {
		final UniModelImpl um = new UniModelImpl();
		um.setValue("aaaaa", (String[])null);

		final UniModelImpl um1 = new UniModelImpl();
		um.putValueTo(um1, "aaaaa");

		AssertUtil.assertEquals(um.containsKey("aaaaa"), um1.containsKey("aaaaa"));
		AssertUtil.assertEquals(um.hasValue("aaaaa"), um1.hasValue("aaaaa"));
		Assert.assertEquals(um.getStringArray("aaaaa").length, um1.getStringArray("aaaaa").length);
		Assert.assertEquals(um.getString("aaaaa"), um1.getString("aaaaa"));
		Assert.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		AssertUtil.assertEquals(um.isArrayValue("aaaaa"), um1.isArrayValue("aaaaa"));
	}

	/**
	 * testputValue3
	 */
	@Test
	public void testputValue3() {
		final UniModelImpl um = new UniModelImpl();
		um.setValue("aaaaa", (String)null);
		um.addValue("aaaaa", (String)null);

		final UniModelImpl um1 = new UniModelImpl();
		um.putValueTo(um1, "aaaaa");

		AssertUtil.assertEquals(um.containsKey("aaaaa"), um1.containsKey("aaaaa"));
		AssertUtil.assertEquals(um.hasValue("aaaaa"), um1.hasValue("aaaaa"));
		Assert.assertEquals(um.getStringArray("aaaaa").length, um1.getStringArray("aaaaa").length);
		Assert.assertEquals(um.getString("aaaaa"), um1.getString("aaaaa"));
		Assert.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		AssertUtil.assertEquals(um.isArrayValue("aaaaa"), um1.isArrayValue("aaaaa"));
	}

	/**
	 * testputValue4
	 */
	@Test
	public void testputValue4() {
		final UniModelImpl um = new UniModelImpl();
		um.setValue("aaaaa", new String[]{null});

		final UniModelImpl um1 = new UniModelImpl();
		um.putValueTo(um1, "aaaaa");

		AssertUtil.assertEquals(um.containsKey("aaaaa"), um1.containsKey("aaaaa"));
		AssertUtil.assertEquals(um.hasValue("aaaaa"), um1.hasValue("aaaaa"));
		Assert.assertEquals(um.getStringArray("aaaaa").length, um1.getStringArray("aaaaa").length);
		Assert.assertEquals(um.getString("aaaaa"), um1.getString("aaaaa"));
		Assert.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		AssertUtil.assertEquals(um.isArrayValue("aaaaa"), um1.isArrayValue("aaaaa"));
	}

	/**
	 * testputValue5
	 */
	@Test
	public void testputValue5() {
		final UniModelImpl um = new UniModelImpl();
		um.addValue("aaaaa", (String)null);

		final UniModelImpl um1 = new UniModelImpl();
		um.putValueTo(um1, "aaaaa");

		AssertUtil.assertEquals(um.containsKey("aaaaa"), um1.containsKey("aaaaa"));
		AssertUtil.assertEquals(um.hasValue("aaaaa"), um1.hasValue("aaaaa"));
		Assert.assertEquals(um.getStringArray("aaaaa").length, um1.getStringArray("aaaaa").length);
		Assert.assertEquals(um.getString("aaaaa"), um1.getString("aaaaa"));
		Assert.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		AssertUtil.assertEquals(um.isArrayValue("aaaaa"), um1.isArrayValue("aaaaa"));

		um.addValue("aaaaa", (String)null);
		um.putValueTo(um1, "aaaaa");

		AssertUtil.assertEquals(um.containsKey("aaaaa"), um1.containsKey("aaaaa"));
		AssertUtil.assertEquals(um.hasValue("aaaaa"), um1.hasValue("aaaaa"));
		Assert.assertEquals(um.getStringArray("aaaaa").length, um1.getStringArray("aaaaa").length);
		Assert.assertEquals(um.getStringArray("aaaaa")[1], um1.getStringArray("aaaaa")[1]);
		Assert.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		AssertUtil.assertEquals(um.isArrayValue("aaaaa"), um1.isArrayValue("aaaaa"));
	}

	/**
	 * testputValue6
	 */
	@Test
	public void testputValue6() {
		final UniModelImpl um = new UniModelImpl();
		um.setValue("aaaaa", (String[])null);
		um.addValue("aaaaa", (String)null);

		final UniModelImpl um1 = new UniModelImpl();
		um.putValueTo(um1, "aaaaa");

		AssertUtil.assertEquals(um.containsKey("aaaaa"), um1.containsKey("aaaaa"));
		AssertUtil.assertEquals(um.hasValue("aaaaa"), um1.hasValue("aaaaa"));
		Assert.assertEquals(um.getStringArray("aaaaa").length, um1.getStringArray("aaaaa").length);
		Assert.assertEquals(um.getString("aaaaa"), um1.getString("aaaaa"));
		Assert.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		AssertUtil.assertEquals(um.isArrayValue("aaaaa"), um1.isArrayValue("aaaaa"));
	}

	/**
	 * testputValue7
	 */
	@Test
	public void testputValue7() {
		final UniModelImpl um = new UniModelImpl();
		um.addValue("aaaaa", (String[])null);

		final UniModelImpl um1 = new UniModelImpl();
		um.putValueTo(um1, "aaaaa");

		AssertUtil.assertEquals(um.containsKey("aaaaa"), um1.containsKey("aaaaa"));
		AssertUtil.assertEquals(um.hasValue("aaaaa"), um1.hasValue("aaaaa"));
		Assert.assertEquals(um.getStringArray("aaaaa").length, um1.getStringArray("aaaaa").length);
		Assert.assertEquals(um.getString("aaaaa"), um1.getString("aaaaa"));
		Assert.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		AssertUtil.assertEquals(um.isArrayValue("aaaaa"), um1.isArrayValue("aaaaa"));

		um.addValue("aaaaa", new String[]{"1", "2"});
		um.putValueTo(um1, "aaaaa");

		AssertUtil.assertEquals(um.containsKey("aaaaa"), um1.containsKey("aaaaa"));
		AssertUtil.assertEquals(um.hasValue("aaaaa"), um1.hasValue("aaaaa"));
		Assert.assertEquals(um.getStringArray("aaaaa").length, um1.getStringArray("aaaaa").length);
		Assert.assertEquals(um.getString("aaaaa"), um1.getString("aaaaa"));
		Assert.assertEquals(um.getStringArray("aaaaa")[1], um1.getStringArray("aaaaa")[1]);
		Assert.assertEquals(um.getStringArray("aaaaa")[2], um1.getStringArray("aaaaa")[2]);
		Assert.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		AssertUtil.assertEquals(um.isArrayValue("aaaaa"), um1.isArrayValue("aaaaa"));
	}

	/**
	 * testputValue8
	 */
	@Test
	public void testputValue8() {
		final UniModelImpl um = new UniModelImpl();
		um.addValue("aaaaa", (String[])null);

		final UniModelImpl um1 = new UniModelImpl();
		um.putValueTo(um1, "aaaaa");

		AssertUtil.assertEquals(um.containsKey("aaaaa"), um1.containsKey("aaaaa"));
		AssertUtil.assertEquals(um.hasValue("aaaaa"), um1.hasValue("aaaaa"));
		Assert.assertEquals(um.getStringArray("aaaaa").length, um1.getStringArray("aaaaa").length);
		Assert.assertEquals(um.getString("aaaaa"), um1.getString("aaaaa"));
		Assert.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		AssertUtil.assertEquals(um.isArrayValue("aaaaa"), um1.isArrayValue("aaaaa"));

		um.addValue("aaaaa", (String)null);
		um.putValueTo(um1, "aaaaa");

		AssertUtil.assertEquals(um.containsKey("aaaaa"), um1.containsKey("aaaaa"));
		AssertUtil.assertEquals(um.hasValue("aaaaa"), um1.hasValue("aaaaa"));
		Assert.assertEquals(um.getStringArray("aaaaa").length, um1.getStringArray("aaaaa").length);
		Assert.assertEquals(um.getString("aaaaa"), um1.getString("aaaaa"));
		Assert.assertEquals(um.getStringArray("aaaaa")[1], um1.getStringArray("aaaaa")[1]);
		Assert.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		AssertUtil.assertEquals(um.isArrayValue("aaaaa"), um1.isArrayValue("aaaaa"));
	}


	/**
	 * testputAll0
	 */
	@Test
	public void testputAll0() {
		final UniModelImpl um = new UniModelImpl();
		um.noValue("aaaaa");

		final UniModelImpl um1 = new UniModelImpl();
		um1.putAll(um);

		AssertUtil.assertEquals(um.containsKey("aaaaa"), um1.containsKey("aaaaa"));
		AssertUtil.assertEquals(um.hasValue("aaaaa"), um1.hasValue("aaaaa"));
		Assert.assertEquals(um.getStringArray("aaaaa").length, um1.getStringArray("aaaaa").length);
		Assert.assertEquals(um.getString("aaaaa"), um1.getString("aaaaa"));
		Assert.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		AssertUtil.assertEquals(um.isArrayValue("aaaaa"), um1.isArrayValue("aaaaa"));
	}

	/**
	 * testputAll1
	 */
	@Test
	public void testputAll1() {
		final UniModelImpl um = new UniModelImpl();
		um.setValue("aaaaa", (String)null);

		final UniModelImpl um1 = new UniModelImpl();
		um1.putAll(um);

		AssertUtil.assertEquals(um.containsKey("aaaaa"), um1.containsKey("aaaaa"));
		AssertUtil.assertEquals(um.hasValue("aaaaa"), um1.hasValue("aaaaa"));
		Assert.assertEquals(um.getStringArray("aaaaa").length, um1.getStringArray("aaaaa").length);
		Assert.assertEquals(um.getString("aaaaa"), um1.getString("aaaaa"));
		Assert.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		AssertUtil.assertEquals(um.isArrayValue("aaaaa"), um1.isArrayValue("aaaaa"));
	}

	/**
	 * testputAll2
	 */
	@Test
	public void testputAll2() {
		final UniModelImpl um = new UniModelImpl();
		um.setValue("aaaaa", (String[])null);

		final UniModelImpl um1 = new UniModelImpl();
		um1.putAll(um);

		AssertUtil.assertEquals(um.containsKey("aaaaa"), um1.containsKey("aaaaa"));
		AssertUtil.assertEquals(um.hasValue("aaaaa"), um1.hasValue("aaaaa"));
		Assert.assertEquals(um.getStringArray("aaaaa").length, um1.getStringArray("aaaaa").length);
		Assert.assertEquals(um.getString("aaaaa"), um1.getString("aaaaa"));
		Assert.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		AssertUtil.assertEquals(um.isArrayValue("aaaaa"), um1.isArrayValue("aaaaa"));
	}

	/**
	 * testputAll3
	 */
	@Test
	public void testputAll3() {
		final UniModelImpl um = new UniModelImpl();
		um.setValue("aaaaa", (String)null);
		um.addValue("aaaaa", (String)null);

		final UniModelImpl um1 = new UniModelImpl();
		um1.putAll(um);

		AssertUtil.assertEquals(um.containsKey("aaaaa"), um1.containsKey("aaaaa"));
		AssertUtil.assertEquals(um.hasValue("aaaaa"), um1.hasValue("aaaaa"));
		Assert.assertEquals(um.getStringArray("aaaaa").length, um1.getStringArray("aaaaa").length);
		Assert.assertEquals(um.getString("aaaaa"), um1.getString("aaaaa"));
		Assert.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		AssertUtil.assertEquals(um.isArrayValue("aaaaa"), um1.isArrayValue("aaaaa"));
	}

	/**
	 * testputAll4
	 */
	@Test
	public void testputAll4() {
		final UniModelImpl um = new UniModelImpl();
		um.setValue("aaaaa", new String[]{null});

		final UniModelImpl um1 = new UniModelImpl();
		um1.putAll(um);

		AssertUtil.assertEquals(um.containsKey("aaaaa"), um1.containsKey("aaaaa"));
		AssertUtil.assertEquals(um.hasValue("aaaaa"), um1.hasValue("aaaaa"));
		Assert.assertEquals(um.getStringArray("aaaaa").length, um1.getStringArray("aaaaa").length);
		Assert.assertEquals(um.getString("aaaaa"), um1.getString("aaaaa"));
		Assert.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		AssertUtil.assertEquals(um.isArrayValue("aaaaa"), um1.isArrayValue("aaaaa"));
	}

	/**
	 * testputAll5
	 */
	@Test
	public void testputAll5() {
		final UniModelImpl um = new UniModelImpl();
		um.addValue("aaaaa", (String)null);

		final UniModelImpl um1 = new UniModelImpl();
		um1.putAll(um);

		AssertUtil.assertEquals(um.containsKey("aaaaa"), um1.containsKey("aaaaa"));
		AssertUtil.assertEquals(um.hasValue("aaaaa"), um1.hasValue("aaaaa"));
		Assert.assertEquals(um.getStringArray("aaaaa").length, um1.getStringArray("aaaaa").length);
		Assert.assertEquals(um.getString("aaaaa"), um1.getString("aaaaa"));
		Assert.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		AssertUtil.assertEquals(um.isArrayValue("aaaaa"), um1.isArrayValue("aaaaa"));

		um.addValue("aaaaa", (String)null);
		um1.putAll(um);

		AssertUtil.assertEquals(um.containsKey("aaaaa"), um1.containsKey("aaaaa"));
		AssertUtil.assertEquals(um.hasValue("aaaaa"), um1.hasValue("aaaaa"));
		Assert.assertEquals(um.getStringArray("aaaaa").length, um1.getStringArray("aaaaa").length);
		Assert.assertEquals(um.getStringArray("aaaaa")[1], um1.getStringArray("aaaaa")[1]);
		Assert.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		AssertUtil.assertEquals(um.isArrayValue("aaaaa"), um1.isArrayValue("aaaaa"));
	}

	/**
	 * testputAll6
	 */
	@Test
	public void testputAll6() {
		final UniModelImpl um = new UniModelImpl();
		um.setValue("aaaaa", (String[])null);
		um.addValue("aaaaa", (String)null);

		final UniModelImpl um1 = new UniModelImpl();
		um1.putAll(um);

		AssertUtil.assertEquals(um.containsKey("aaaaa"), um1.containsKey("aaaaa"));
		AssertUtil.assertEquals(um.hasValue("aaaaa"), um1.hasValue("aaaaa"));
		Assert.assertEquals(um.getStringArray("aaaaa").length, um1.getStringArray("aaaaa").length);
		Assert.assertEquals(um.getString("aaaaa"), um1.getString("aaaaa"));
		Assert.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		AssertUtil.assertEquals(um.isArrayValue("aaaaa"), um1.isArrayValue("aaaaa"));
	}

	/**
	 * testputAll7
	 */
	@Test
	public void testputAll7() {
		final UniModelImpl um = new UniModelImpl();
		um.addValue("aaaaa", (String[])null);

		final UniModelImpl um1 = new UniModelImpl();
		um1.putAll(um);

		AssertUtil.assertEquals(um.containsKey("aaaaa"), um1.containsKey("aaaaa"));
		AssertUtil.assertEquals(um.hasValue("aaaaa"), um1.hasValue("aaaaa"));
		Assert.assertEquals(um.getStringArray("aaaaa").length, um1.getStringArray("aaaaa").length);
		Assert.assertEquals(um.getString("aaaaa"), um1.getString("aaaaa"));
		Assert.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		AssertUtil.assertEquals(um.isArrayValue("aaaaa"), um1.isArrayValue("aaaaa"));

		um.addValue("aaaaa", new String[]{"1", "2"});
		um1.putAll(um);

		AssertUtil.assertEquals(um.containsKey("aaaaa"), um1.containsKey("aaaaa"));
		AssertUtil.assertEquals(um.hasValue("aaaaa"), um1.hasValue("aaaaa"));
		Assert.assertEquals(um.getStringArray("aaaaa").length, um1.getStringArray("aaaaa").length);
		Assert.assertEquals(um.getString("aaaaa"), um1.getString("aaaaa"));
		Assert.assertEquals(um.getStringArray("aaaaa")[1], um1.getStringArray("aaaaa")[1]);
		Assert.assertEquals(um.getStringArray("aaaaa")[2], um1.getStringArray("aaaaa")[2]);
		Assert.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		AssertUtil.assertEquals(um.isArrayValue("aaaaa"), um1.isArrayValue("aaaaa"));
	}

	/**
	 * testputAll8
	 */
	@Test
	public void testputAll8() {
		final UniModelImpl um = new UniModelImpl();
		um.addValue("aaaaa", (String[])null);

		final UniModelImpl um1 = new UniModelImpl();
		um1.putAll(um);

		AssertUtil.assertEquals(um.containsKey("aaaaa"), um1.containsKey("aaaaa"));
		AssertUtil.assertEquals(um.hasValue("aaaaa"), um1.hasValue("aaaaa"));
		Assert.assertEquals(um.getStringArray("aaaaa").length, um1.getStringArray("aaaaa").length);
		Assert.assertEquals(um.getString("aaaaa"), um1.getString("aaaaa"));
		Assert.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		AssertUtil.assertEquals(um.isArrayValue("aaaaa"), um1.isArrayValue("aaaaa"));

		um.addValue("aaaaa", (String)null);
		um1.putAll(um);

		AssertUtil.assertEquals(um.containsKey("aaaaa"), um1.containsKey("aaaaa"));
		AssertUtil.assertEquals(um.hasValue("aaaaa"), um1.hasValue("aaaaa"));
		Assert.assertEquals(um.getStringArray("aaaaa").length, um1.getStringArray("aaaaa").length);
		Assert.assertEquals(um.getString("aaaaa"), um1.getString("aaaaa"));
		Assert.assertEquals(um.getStringArray("aaaaa")[1], um1.getStringArray("aaaaa")[1]);
		Assert.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		AssertUtil.assertEquals(um.isArrayValue("aaaaa"), um1.isArrayValue("aaaaa"));
	}


	/**
	 * testaddAll0
	 */
	@Test
	public void testaddAll0() {
		final UniModelImpl um = new UniModelImpl();
		um.noValue("aaaaa");

		final UniModelImpl um1 = new UniModelImpl();
		um1.addAll(um);

		AssertUtil.assertEquals(um.containsKey("aaaaa"), um1.containsKey("aaaaa"));
		AssertUtil.assertEquals(um.hasValue("aaaaa"), um1.hasValue("aaaaa"));
		Assert.assertEquals(um.getStringArray("aaaaa").length, um1.getStringArray("aaaaa").length);
		Assert.assertEquals(um.getString("aaaaa"), um1.getString("aaaaa"));
		Assert.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		AssertUtil.assertEquals(um.isArrayValue("aaaaa"), um1.isArrayValue("aaaaa"));
	}

	/**
	 * testaddAll1
	 */
	@Test
	public void testaddAll1() {
		final UniModelImpl um = new UniModelImpl();
		um.addValue("aaaaa", (String)null);

		final UniModelImpl um1 = new UniModelImpl();
		um1.addAll(um);

		Assert.assertTrue(um1.containsKey("aaaaa"));
		Assert.assertTrue(um1.hasValue("aaaaa"));
		Assert.assertEquals(1, um1.getArraySize("aaaaa"));
		Assert.assertNull(um1.getStringArray("aaaaa")[0]);
		Assert.assertEquals("", um1.getString("aaaaa"));
		Assert.assertFalse(um1.isArrayValue("aaaaa"));
	}

	/**
	 * testaddAll2
	 */
	@Test
	public void testaddAll2() {
		final UniModelImpl um = new UniModelImpl();
		um.setValue("aaaaa", (String)null);

		final UniModelImpl um1 = new UniModelImpl();
		um1.addAll(um);

		Assert.assertTrue(um1.containsKey("aaaaa"));
		Assert.assertTrue(um1.hasValue("aaaaa"));
		Assert.assertEquals(1, um1.getArraySize("aaaaa"));
		Assert.assertNull(um1.getStringArray("aaaaa")[0]);
		Assert.assertEquals("", um1.getString("aaaaa"));
		Assert.assertFalse(um1.isArrayValue("aaaaa"));
	}

	/**
	 * testaddAll3
	 */
	@Test
	public void testaddAll3() {
		final UniModelImpl um = new UniModelImpl();
		um.addValue("aaaaa", (String)null);

		final UniModelImpl um1 = new UniModelImpl();
		um1.addValue("aaaaa", (String)null);
		um1.addAll(um);

		Assert.assertTrue(um1.containsKey("aaaaa"));
		Assert.assertTrue(um1.hasValue("aaaaa"));
		Assert.assertEquals(2, um1.getArraySize("aaaaa"));
		Assert.assertNull(um1.getStringArray("aaaaa")[0]);
		Assert.assertNull(um1.getStringArray("aaaaa")[1]);
		Assert.assertEquals("", um1.getString("aaaaa"));
		Assert.assertTrue(um1.isArrayValue("aaaaa"));
	}
}
