package core.config;

import org.junit.Assert;
import org.junit.Test;

/**
 * Factoryテスト
 * @author Tadashi Nakayama
 */
public class TestFactory {

	/**
	 * インターフェースインスタンス化テスト
	 * デフォルトメソッド
	 */
	@Test
	public void testInterface() {
		final TestInterface ti = Factory.create(TestInterface.class);
		Assert.assertEquals("testMethod", ti.testMethod());
	}

	/**
	 * abstractクラスインスタンス化テスト
	 */
	@Test
	public void testAbstract() {
		final TestAbstract ta = Factory.create(TestAbstract.class);
		Assert.assertNull(ta);
	}

	/**
	 * インターフェースインスタンス化テスト
	 * デフォルトメソッドなし
	 */
	@Test
	public void testInterface2() {
		final TestInterface2 ti = Factory.create(TestInterface2.class);
		Assert.assertNull(ti.testMethod());
	}

	/**
	 * テストインタフェース
	 * @author tadashi
	 */
	public interface TestInterface {
		/**
		 * デフォルトメソッド
		 * @return 文字列
		 */
		default String testMethod() {
			System.out.println("testMethod");
			return "testMethod";
		}
	}

	/**
	 * abstractクラス
	 * @author tadashi
	 *
	 */
	public abstract class TestAbstract {
		/**
		 * テスト対象メソッド
		 * @return 文字列
		 */
		public String testMethod() {
			System.out.println("testMethodA");
			return "testMethodA";
		}
	}

	/**
	 * テストインターフェース
	 * @author tadashi
	 *
	 */
	public interface TestInterface2 {
		/**
		 * テスト対象メソッド
		 * @return 文字列
		 */
		String testMethod();
	}
}
