package project.view.tag;

import javax.servlet.jsp.JspException;

import online.view.tag.BaseTag;
import core.util.MojiUtil;

/**
 * 改行コード変換タグライブラリ
 *
 * @author Tadashi Nakayama
 * @version 1.0.0
 */
public final class NewLineTag extends BaseTag {
	/** serialVersionUID */
	private static final long serialVersionUID = 5581415208725369946L;

	/** 変数用変数 */
	private String var = null;
	/** 変換元変数 */
	private String value = null;
	/** 前置子 */
	private String pre = null;
	/** 後置子 */
	private String post = getDefault();
	/** 変換元文字 */
	private String type = MojiUtil.RET_CODE_CRLF;

	/**
	 * デフォルトタグ取得
	 * @return デフォルトタグ
	 */
	private String getDefault() {
		return "<br />";
	}

	/**
	 * リリース処理
	 */
	@Override
	public void release() {
		this.var = null;
		this.value = null;
		this.pre = null;
		this.post = getDefault();
		this.type = MojiUtil.RET_CODE_CRLF;
	}

	/**
	 * 変数設定
	 *
	 * @param val 保存変数名文字列
	 */
	public void setVar(final String val) {
		this.var = val;
	}

	/**
	 * 変換元設定
	 *
	 * @param val 変換元
	 */
	public void setValue(final String val) {
		this.value = val;
	}

	/**
	 * 変換元タイプ設定
	 *
	 * @param val 変換元タイプ
	 */
	public void setType(final String val) {
		if ("\\r".equalsIgnoreCase(val)) {
			this.type = MojiUtil.RET_CODE_CR;
		} else if ("\\n".equalsIgnoreCase(val)) {
			this.type = MojiUtil.RET_CODE_LF;
		} else if ("\\r\\n".equalsIgnoreCase(val)) {
			this.type = MojiUtil.RET_CODE_CRLF;
		} else {
			this.type = val;
		}
	}

	/**
	 * 前置子設定
	 *
	 * @param val 前置子
	 */
	public void setPre(final String val) {
		this.pre = val;
	}

	/**
	 * 後置子設定
	 *
	 * @param val 後置子
	 */
	public void setPost(final String val) {
		this.post = val;
	}

	/**
	 * @see javax.servlet.jsp.tagext.TagSupport#doStartTag()
	 */
	@Override
	public int doStartTag() throws JspException {
		try {
			doTag();
			return SKIP_BODY;
		} finally {
			release();
		}
	}

	/**
	 * タグ処理
	 */
	public void doTag() {
		// アトリビュートクリア
		if (this.var != null) {
			this.pageContext.removeAttribute(this.var);
		}

		if (this.value != null) {
			String str = this.value;

			String rep = this.post;
			final StringBuilder sb = new StringBuilder();
			if (this.pre != null) {
				sb.append(this.pre);
				rep = rep + this.pre;

				if (str.endsWith(this.type)) {
					str = str.substring(0, str.length() - this.type.length());
				}
			}
			sb.append(str.replace(this.type, rep));
			if (this.pre != null) {
				sb.append(this.post);
			}
			super.output(this.var, sb);
		}
	}
}
