CREATE TABLE TR_SEARCH_PATTERN
(
    ID                          BIGINT         PRIMARY KEY,
    PATTERN_NAME                VARCHAR(256)  NOT NULL,
    GID                         VARCHAR(16)   NOT NULL,
    QUERY                       VARCHAR(4000) NOT NULL,
    PREFERENCE                  CHAR(1)       NOT NULL,
    GAMEN_NAME                  VARCHAR(16)   NOT NULL,
    INSERT_DATETIME             TIMESTAMP    NOT NULL,
    INSERT_ID                   VARCHAR(32)  NOT NULL,
    UPDATE_DATETIME             TIMESTAMP    NOT NULL,
    UPDATE_ID                   VARCHAR(32)  NOT NULL,
    VERSION                     INTEGER      NOT NULL DEFAULT 1,
    CONSTRAINT TR_SEARCH_PATTERN_UIX01 UNIQUE (PATTERN_NAME, GID, INSERT_ID)
)
;

COMMENT ON TABLE TR_SEARCH_PATTERN IS 'パターン管理';
COMMENT ON COLUMN TR_SEARCH_PATTERN.ID IS 'ID';
COMMENT ON COLUMN TR_SEARCH_PATTERN.PATTERN_NAME IS 'パターン名';
COMMENT ON COLUMN TR_SEARCH_PATTERN.GID IS '画面ID';
COMMENT ON COLUMN TR_SEARCH_PATTERN.QUERY IS 'クエリ文字列';
COMMENT ON COLUMN TR_SEARCH_PATTERN.PREFERENCE IS '優先フラグ';
COMMENT ON COLUMN TR_SEARCH_PATTERN.GAMEN_NAME IS '画面名';
COMMENT ON COLUMN TR_SEARCH_PATTERN.INSERT_DATETIME IS '作成日時';
COMMENT ON COLUMN TR_SEARCH_PATTERN.INSERT_ID IS '作成者';
COMMENT ON COLUMN TR_SEARCH_PATTERN.UPDATE_DATETIME IS '更新日時';
COMMENT ON COLUMN TR_SEARCH_PATTERN.UPDATE_ID IS '更新者';
COMMENT ON COLUMN TR_SEARCH_PATTERN.VERSION IS 'バージョン';
