package batch.status;

import java.sql.Connection;
import java.sql.Timestamp;
import java.util.EnumSet;
import java.util.List;

/**
 * ジョブ管理テーブル取得／更新
 *
 * @author Tadashi Nakayama
 * @version 1.0.0
 */
public interface JobStatus {

	/**
	 * ジョブ管理状態取得
	 *
	 * @param conn コネクション
	 * @param hostId ホストID
	 * @param ts タイムスタンプ
	 * @return ジョブ管理テーブル情報
	 */
	List<Job> getJobListByTimestamp(Connection conn, String hostId, Timestamp ts);

	/**
	 * ジョブ管理状態取得
	 *
	 * @param conn コネクション
	 * @param hostId ホストID
	 * @param sts ステータス
	 * @return ジョブ管理テーブル情報
	 */
	List<Job> getJobListByStatus(Connection conn, String hostId, EnumSet<JobState> sts);

	/**
	 * ジョブ管理テーブル項目取得（排他）
	 *
	 * @param conn コネクション
	 * @param seq ジョブ連番
	 * @return ジョブ管理テーブル情報
	 */
	Job getJobWithLock(Connection conn, long seq);

	/**
	 * ジョブ管理テーブル項目取得
	 *
	 * @param conn コネクション
	 * @param seq ジョブ連番
	 * @return 取得項目値
	 */
	Job getJob(Connection conn, long seq);

	/**
	 * ジョブ管理レコード作成
	 *
	 * @param conn コネクション
	 * @param job ジョブ管理
	 * @return 採番された番号
	 */
	long insertJob(Connection conn, Job job);

	/**
	 * ジョブ管理状態更新
	 *
	 * @param conn コネクション
	 * @param seq ジョブ連番
	 * @param host ホスト名
	 * @param msg メッセージ
	 * @param sts ステータス
	 * @return 更新レコード数
	 */
	int updateJobStatus(Connection conn, long seq, String host, String msg, JobState sts);

	/**
	 * ジョブ管理レコード削除
	 *
	 * @param conn コネクション
	 * @param seq ジョブ連番
	 * @return 削除件数
	 */
	int deleteJob(Connection conn, long seq);
}
