package batch.base;


/**
 * バッチ実行
 *
 * @author Tadashi Nakayama
 * @version 1.0.0
 */
public interface BatchProcessor {

	/**
	 * 前処理
	 *
	 * @param args 引数
	 * @return 処理結果
	 */
	int preprocess(String... args);

	/**
	 * 実処理
	 *
	 * @param args 引数
	 * @return 処理結果
	 */
	int process(String... args);

	/**
	 * 後処理
	 *
	 * @param exitCode 実行結果
	 * @return 処理結果
	 */
	int postprocess(int exitCode);
}
