require 'test_helper'

class MountainsControllerTest < ActionController::TestCase
  setup do
    @mountain = mountains(:one)
  end

  test "should get index" do
    get :index
    assert_response :success
    assert_not_nil assigns(:mountains)
  end

  test "should get new" do
    get :new
    assert_response :success
  end

  test "should create mountain" do
    assert_difference('Mountain.count') do
      post :create, mountain: { district: @mountain.district, elevation: @mountain.elevation, fl_100meizan: @mountain.fl_100meizan, fl_200meizan: @mountain.fl_200meizan, fl_300meizan: @mountain.fl_300meizan, fl_aizu: @mountain.fl_aizu, fl_gumma: @mountain.fl_gumma, fl_hana: @mountain.fl_hana, fl_hokkaido: @mountain.fl_hokkaido, fl_kansai: @mountain.fl_kansai, fl_kanto: @mountain.fl_kanto, fl_kyuushuu: @mountain.fl_kyuushuu, fl_niigata: @mountain.fl_niigata, fl_shikoku: @mountain.fl_shikoku, fl_shinhana: @mountain.fl_shinhana, fl_shinhyaku: @mountain.fl_shinhyaku, fl_tochigi: @mountain.fl_tochigi, fl_tohoku: @mountain.fl_tohoku, fl_utsukushima: @mountain.fl_utsukushima, fl_yama1000: @mountain.fl_yama1000, fl_yamanashi: @mountain.fl_yamanashi, id: @mountain.id, kana: @mountain.kana, latitude: @mountain.latitude, longitude: @mountain.longitude, map025: @mountain.map025, map050: @mountain.map050, map200: @mountain.map200, name1: @mountain.name1, name2: @mountain.name2, name3: @mountain.name3, number_300meizan: @mountain.number_300meizan, prefs: @mountain.prefs, uname: @mountain.uname }
    end

    assert_redirected_to mountain_path(assigns(:mountain))
  end

  test "should show mountain" do
    get :show, id: @mountain
    assert_response :success
  end

  test "should get edit" do
    get :edit, id: @mountain
    assert_response :success
  end

  test "should update mountain" do
    put :update, id: @mountain, mountain: { district: @mountain.district, elevation: @mountain.elevation, fl_100meizan: @mountain.fl_100meizan, fl_200meizan: @mountain.fl_200meizan, fl_300meizan: @mountain.fl_300meizan, fl_aizu: @mountain.fl_aizu, fl_gumma: @mountain.fl_gumma, fl_hana: @mountain.fl_hana, fl_hokkaido: @mountain.fl_hokkaido, fl_kansai: @mountain.fl_kansai, fl_kanto: @mountain.fl_kanto, fl_kyuushuu: @mountain.fl_kyuushuu, fl_niigata: @mountain.fl_niigata, fl_shikoku: @mountain.fl_shikoku, fl_shinhana: @mountain.fl_shinhana, fl_shinhyaku: @mountain.fl_shinhyaku, fl_tochigi: @mountain.fl_tochigi, fl_tohoku: @mountain.fl_tohoku, fl_utsukushima: @mountain.fl_utsukushima, fl_yama1000: @mountain.fl_yama1000, fl_yamanashi: @mountain.fl_yamanashi, id: @mountain.id, kana: @mountain.kana, latitude: @mountain.latitude, longitude: @mountain.longitude, map025: @mountain.map025, map050: @mountain.map050, map200: @mountain.map200, name1: @mountain.name1, name2: @mountain.name2, name3: @mountain.name3, number_300meizan: @mountain.number_300meizan, prefs: @mountain.prefs, uname: @mountain.uname }
    assert_redirected_to mountain_path(assigns(:mountain))
  end

  test "should destroy mountain" do
    assert_difference('Mountain.count', -1) do
      delete :destroy, id: @mountain
    end

    assert_redirected_to mountains_path
  end
end
