require 'test_helper'

class RecordsControllerTest < ActionController::TestCase
  setup do
    @record = records(:one)
  end

  test "should get index" do
    get :index
    assert_response :success
    assert_not_nil assigns(:records)
  end

  test "should get new" do
    get :new
    assert_response :success
  end

  test "should create record" do
    assert_difference('Record.count') do
      post :create, record: { body: @record.body, end_d: @record.end_d, id: @record.id, mountain_id: @record.mountain_id, publish_d: @record.publish_d, start_d: @record.start_d, title: @record.title, user_id: @record.user_id }
    end

    assert_redirected_to record_path(assigns(:record))
  end

  test "should show record" do
    get :show, id: @record
    assert_response :success
  end

  test "should get edit" do
    get :edit, id: @record
    assert_response :success
  end

  test "should update record" do
    put :update, id: @record, record: { body: @record.body, end_d: @record.end_d, id: @record.id, mountain_id: @record.mountain_id, publish_d: @record.publish_d, start_d: @record.start_d, title: @record.title, user_id: @record.user_id }
    assert_redirected_to record_path(assigns(:record))
  end

  test "should destroy record" do
    assert_difference('Record.count', -1) do
      delete :destroy, id: @record
    end

    assert_redirected_to records_path
  end
end
