class SessionsController < ApplicationController
  skip_before_filter :authorize
  before_filter :check_logined

  def new
  end

  # ログイン判定処理（bcrypt-ruby利用版）
  #def create
  #  user = User.find_by_name(params[:name])
  #  if user and user.authenticate(params[:password])
  #    session[:user_id]=user.id
  #    redirect_to admin_url
  #  else
  #    redirect_to login_url, alert: "error"
  #  end
  #end

  # ログアウト処理
  def destroy
    session[:user_id] = nil;
    redirect_to users_url
  end

  # ログイン判定処理（認証メソッド自作版）
  def check_logined
    if session[:usr] then
      begin
        @usr = User.find(session[:usr])
      rescue ActiveRecord::RecordNotFound
        reset_session
      end
    end
    unless @usr
      flash[:referer] = request.fullpath
      redirect_to :controller => 'login', :action => 'index'
    end
  end

end
