
#include "gtest/gtest.h"

#include "mt_typelist.h"
#include "mt_type_identity.h"

namespace mt {

class TypelistEraseTest : public ::testing::Test
{
public:
    virtual void SetUp()
    {}
    virtual void TearDown()
    {}
};

TEST_F(TypelistEraseTest, test)
{
    typedef MakeTypelist<char, short, long, long long>::Result Char_Short_Long_LongLong_types;

    typedef Erase<Char_Short_Long_LongLong_types, long long>::Result Char_Short_Long_types;
    typedef MakeTypelist<char, short, long>::Result ExpectedTypes1;

    bool is_identical_type = IsIdentical<Char_Short_Long_types, ExpectedTypes1>::value;

    EXPECT_EQ(is_identical_type, true);

    typedef Erase<Char_Short_Long_LongLong_types, char>::Result Short_Long_LongLong_types;
    typedef MakeTypelist<short, long, long long>::Result ExpectedType2;

    is_identical_type = IsIdentical<Short_Long_LongLong_types, ExpectedType2>::value;

    EXPECT_EQ(is_identical_type, true);
}

TEST_F(TypelistEraseTest, EraseTypelistTest)
{
    typedef MakeTypelist<char, short, long, long long,
                         float, double, char[10]
            >::Result TestInputTypes;

    typedef MakeTypelist<short, long long, double>::Result TypesToRemove1;

    typedef Erase<TestInputTypes, TypesToRemove1>::Result ErasedTypes1;

    bool is_identical_type = IsIdentical<ErasedTypes1,
                                         MakeTypelist<char, long, float, char[10]>::Result>::value;

    EXPECT_EQ(is_identical_type, true);

    typedef MakeTypelist<long>::Result TypesToRemove2;
    typedef Erase<TestInputTypes, TypesToRemove2>::Result ErasedTypes2;

    is_identical_type = IsIdentical<ErasedTypes2,
                                    MakeTypelist<char, short, long long, float, double, char[10]>::Result>::value;
    EXPECT_EQ(is_identical_type, true);

    typedef MakeTypelist<char, char[10]>::Result TypesToRemove3;
    typedef Erase<TestInputTypes, TypesToRemove3>::Result ErasedTypes3;
    is_identical_type = IsIdentical<ErasedTypes3,
                                    MakeTypelist<short, long, long long, float, double>::Result>::value;
    EXPECT_EQ(is_identical_type, true);
}

} // namespace mt

