
#ifndef INC_MT_TYPELIST_H_
#define INC_MT_TYPELIST_H_

namespace mt {

class NullType
{};

struct EmptyType
{};

template <typename T, typename U>
struct Typelist
{
    typedef T Head;
    typedef U Tail;
};

template <typename T1 = NullType, typename T2 = NullType, typename T3 = NullType, typename T4 = NullType,
          typename T5 = NullType, typename T6 = NullType, typename T7 = NullType, typename T8 = NullType,
          typename T9 = NullType, typename T10 = NullType, typename T11 = NullType, typename T12 = NullType,
          typename T13 = NullType, typename T14 = NullType, typename T15 = NullType, typename T16 = NullType,
          typename T17 = NullType, typename T18 = NullType, typename T19 = NullType, typename T20 = NullType,
          typename T21 = NullType, typename T22 = NullType, typename T23 = NullType, typename T24 = NullType>
struct MakeTypelist
{
    typedef Typelist<T1,
                     typename MakeTypelist<T2, T3, T4, T5, T6, T7, T8, T9,
                                           T10, T11, T12, T13, T14, T15, T16,
                                           T17, T18, T19, T20, T21, T22, T23, T24
                                          >::Result> Result;
};

template <typename T>
struct MakeTypelist<T, NullType>
{
    typedef Typelist<T, NullType> Result;
};

template <typename TL, typename T>
struct Append
{
    typedef Typelist<typename TL::Head, typename Append<typename TL::Tail, T>::Result > Result;
};

template <typename T, typename U>
struct Append<Typelist<T, NullType>, U>
{
    typedef Typelist<T, U> Result;
};

template <typename TL, typename T>
struct Erase
{
    typedef Typelist<typename TL::Head, typename Erase<typename TL::Tail, T>::Result> Result;
};

template <typename T, typename U>
struct Erase<Typelist<T, U>, T>
{
    typedef U Result;
};

template <typename TL, typename T, typename U>
struct Erase< TL, Typelist<T, U> >
{
    typedef typename Erase<typename Erase<TL, T>::Result, U>::Result Result;
};

template <typename TL, typename T>
struct Erase< TL, Typelist<T, NullType> >
{
    typedef typename Erase<TL, T>::Result Result;
};

template <typename TL, typename T>
struct IndexOf
{
    static const unsigned int value = IndexOf<typename TL::Tail, T>::value;
};

template <typename T, typename U>
struct IndexOf<Typelist<T, U>, T>
{
    static const unsigned int value = 0u;
};

template <typename TL, unsigned int N>
struct TypeAt : public TypeAt<typename TL::Tail, N - 1>
{
};

template <typename T, typename U>
struct TypeAt< Typelist<T, U>, 0>
{
    typedef T Result;
};

template <typename TL, unsigned int N>
struct TypelistAt : public TypelistAt <typename TL::Tail, N - 1>
{
};

template <typename T, typename U>
struct TypelistAt< Typelist<T, U>, 0>
{
    typedef Typelist<T, U> Result;
};

template <typename TL, typename V>
struct TypelistOf : public TypelistOf<typename TL::Tail, V>
{};

template <typename T, typename U>
struct TypelistOf< Typelist<T, U>, T>
{
    typedef Typelist<T, U> Result;
};

} // namespace mt

#endif // INC_MT_TYPELIST_H_

