
#ifndef INC_MT_TUPLE_H_
#define INC_MT_TUPLE_H_

#include "mt_typelist.h"

namespace mt {

template <typename TL>
class Tuple;

template <typename T, typename U>
class Tuple< Typelist<T, U> > : public Tuple<U>
{
public:
    Tuple()
        : Tuple<U>(), value_()
    {}

    template <unsigned int N>
    const typename TypeAt< Typelist<T, U>, N>::Result& get() const
    {
        return this->Tuple<typename TypelistAt< Typelist<T, U>, N>::Result>::doGet();
    }

    template <unsigned int N>
    typename TypeAt< Typelist<T, U>, N>::Result& get()
    {
        return this->Tuple<typename TypelistAt< Typelist<T, U>, N>::Result>::doGet();
    }

    template <typename V>
    const V& get() const
    {
        return this->Tuple<typename TypelistOf< Typelist<T, U>, V >::Result>::doGet();
    }

    template <typename V>
    V& get()
    {
        return this->Tuple<typename TypelistOf< Typelist<T, U>, V >::Result>::doGet();
    }

    template <unsigned int N, typename V>
    void set(const V& value)
    {
        this->Tuple<typename TypelistAt< Typelist<T, U>, N>::Result>::doSet(value);
    }

    template <typename V>
    void set(const V& value)
    {
        this->Tuple<typename TypelistOf< Typelist<T, U>, V>::Result>::doSet(value);
    }

protected:
    const T& doGet() const
    {
        return value_;
    }

    T& doGet()
    {
        return value_;
    }

    void doSet(const T& value)
    {
        value_ = value;
    }
    
private:
    T value_;
};

template <typename T>
class Tuple< Typelist<T, NullType> >
{
public:
    Tuple()
        : value_()
    {}

protected:
    const T& doGet() const
    {
        return value_;
    }

    T& doGet()
    {
        return value_;
    }

    void doSet(const T& value)
    {
        value_ = value;
    }
    

private:
    T value_;
};

} // namespace mt

#endif // INC_MT_TUPLE_H_

