
#ifndef INC_MT_ITERATOR_TYPE_DETECTOR_H_
#define INT_MT_ITERATOR_TYPE_DETECTOR_H_

#include "mt_sfinae.h"

namespace mt {

template <typename T>
struct HasIteratorType
{
private:
    template <typename X>
    static YesTypeWith1TemplateParam<X, typename X::iterator> test(X*);

    template <typename X>
    static NoType test(...);
public:
    static const bool value = (sizeof(test<T>(0)) != sizeof(NoType));
};

template <typename T>
struct HasConstIteratorType
{
private:
    template <typename X>
    static YesTypeWith1TemplateParam<X, typename X::const_iterator> test(X*);

    template <typename X>
    static NoType test(...);
public:
    static const bool value = (sizeof(test<T>(0)) != sizeof(NoType));
};

} // namespace mt

#endif // INC_ITERATOR_TYPE_DETECTOR_H_


