
#ifndef INC_MT_CONTAINER_FOREACH_H_
#define INC_MT_CONTAINER_FOREACH_H_

#include "mt_mpl.h"
#include "mt_range.h"

namespace mt {

struct AnyCast
{
    template <typename T>
    operator Type2Type<T> () const
    {
        return Type2Type<T>(); 
    }
};

struct IteratorPairBase
{
    virtual ~IteratorPairBase()
    {}

    operator bool() const
    {
        return false;
    }
};

template <typename Container>
struct IteratorPair : public IteratorPairBase
{
    IteratorPair(Container& cont)
        : container(cont), it_beg(begin(cont)), it_end(end(cont))
    {}

    Container& container;
    mutable typename GetIteratorType<Container>::Result it_beg;
    mutable typename GetIteratorType<Container>::Result it_end;
};

template <typename Container>
struct ConstIteratorPair : public IteratorPairBase
{
    ConstIteratorPair(const Container& cont)
        : container(cont), it_beg(cbegin(cont)), it_end(cend(cont))
    {}

    const Container& container;
    mutable typename GetConstIteratorType<Container>::Result it_beg;
    mutable typename GetConstIteratorType<Container>::Result it_end;
};

template <typename Container>
IteratorPair<Container> getIteratorPair(Container& cont)
{
    return IteratorPair<Container>(cont);
}

template <typename Container>
ConstIteratorPair<Container> getConstIteratorPair(const Container& cont)
{
    return ConstIteratorPair<Container>(cont);
}

template <typename Container>
bool isDone(const IteratorPairBase& it_pair, Type2Type<Container> )
{
    return (static_cast< const IteratorPair<Container>& >(it_pair)).it_beg
           != (static_cast< const IteratorPair<Container>& >(it_pair)).it_end;
}

template <typename Container>
bool isDoneConst(const IteratorPairBase& it_pair, Type2Type<Container> )
{
    return (static_cast< const ConstIteratorPair<Container>& >(it_pair)).it_beg
           != (static_cast< const ConstIteratorPair<Container>& >(it_pair)).it_end;
}

template <typename Container>
void next(const IteratorPairBase& it_pair, Type2Type<Container> )
{
    ++(static_cast< const IteratorPair<Container>& >(it_pair)).it_beg;
    return;
}

template <typename Container>
void nextConst(const IteratorPairBase& it_pair, Type2Type<Container> )
{
    ++(static_cast< const ConstIteratorPair<Container>& >(it_pair)).it_beg;
    return;
}

template <typename Container>
typename GetValueType<Container>::Result& deref(const IteratorPairBase& it_pair, Type2Type<Container>)
{
    return *((static_cast< const IteratorPair<Container>& >(it_pair)).it_beg);
}

template <typename Container>
const typename GetValueType<Container>::Result& derefConst(const IteratorPairBase& it_pair, Type2Type<Container>)
{
    return *((static_cast< const IteratorPair<Container>& >(it_pair)).it_beg);
}

template <typename Container>
Type2Type<Container> getEncodedType(const Container& cont)
{
    return Type2Type<Container>();
}

#if 0
template <typename ArrayType, size_t N>
Type2Type<ArrayType[N]> getEncodedType(const ArrayType (&)[N])
{
    return Type2Type<ArrayType[N]>();
}
#endif

} // namespace mt

#define CONTAINER_FOREACH(item, container) \
    if (const mt::IteratorPairBase& it_pair = mt::getIteratorPair(container)) {} \
    else \
        for (bool more = true; more && mt::isDone(it_pair, true ? mt::AnyCast() : mt::getEncodedType(container)); \
             mt::next(it_pair, true ? mt::AnyCast() : mt::getEncodedType(container))) \
            if ((more = false)) {} \
            else \
                for (item = mt::deref(it_pair, true ? mt::AnyCast() : mt::getEncodedType(container)); !more; more = true)

#define CONTAINER_FOREACH_CONST(item, container) \
    if (const mt::IteratorPairBase& it_pair = mt::getConstIteratorPair(container)) {} \
    else \
        for (bool more = true; more && mt::isDoneConst(it_pair, true ? mt::AnyCast() : mt::getEncodedType(container)); \
             mt::nextConst(it_pair, true ? mt::AnyCast() : mt::getEncodedType(container))) \
            if ((more = false)) {} \
            else \
                for (item = mt::derefConst(it_pair, true ? mt::AnyCast() : mt::getEncodedType(container)); !more; more = true)
    
#endif // INC_MT_CONTAINER_FOREACH_H_
