
#ifndef INC_MT_AUTO_PTR_H_
#define INC_MT_AUTO_PTR_H_

#include <assert.h>
#include "mt_static_assert.h"

namespace mt {

template <typename T>
class AutoPtr
{
public:
    AutoPtr()
        : raw_ptr_(0)
    {}

    AutoPtr(T* ptr)
        : raw_ptr_(ptr)
    {}

    AutoPtr(AutoPtr& rhs)
        : raw_ptr_(rhs.get())
    {
        rhs.release();
    }

    ~AutoPtr()
    {
        reset();
    }

    void release()
    {
        raw_ptr_ = 0;
    }

    void set(T* new_ptr)
    {
        assert(raw_ptr_ == 0);
        raw_ptr_ = new_ptr;
        return;
    }

    T* get()
    {
        return raw_ptr_;
    }

    const T* get() const
    {
        return raw_ptr_;
    }

    void reset()
    {
        STATIC_ASSERT(sizeof(*raw_ptr_) > 0);
        delete raw_ptr_;
        raw_ptr_ = 0;
    }

    AutoPtr& operator=(AutoPtr& rhs)
    {
        this->reset();
        this->set(rhs.get());
        rhs.release();
        return *this;
    }

    T* operator->()
    {
        return raw_ptr_;
    }

    T& operator*()
    {
        return *raw_ptr_;
    }

    const T& operator*() const
    {
        return *raw_ptr_;
    }

    const T* operator->() const
    {
        return raw_ptr_;
    }

private:
    // Won't allow conventional copy semantics from another const AutoPtr object.
    AutoPtr(const AutoPtr& rhs);
    AutoPtr& operator=(const AutoPtr& rhs);

    T* raw_ptr_;
};

} // namespace mt

#endif // INC_MT_AUTO_PTR_H

