
#ifndef INC_CM_THREAD_IS_MAIN_THREAD_H_
#define INC_CM_THREAD_IS_MAIN_THREAD_H_

#if __linux__
#include <sys/types.h>
#include <linux/unistd.h>

namespace cm {

inline bool isMainThread()
{
    return gettid() == getpid();
}

} // namespace

#elif ((__FreeBSD__) || (__MACH__ && __APPLE__))
namespace cm {

#include <pthread.h>

inline bool isMainThread()
{
    return pthread_main_np();
}

} // namespace

#else
#error "portable way to define isMainThread() inline function is not found."
#endif

#endif // INC_CM_THREAD_IS_MAIN_THREAD_H_

